/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;

public class StoresModel
extends LoadableDetachableModel<List<StoreInfo>> {
    IModel workspace;

    public StoresModel(IModel workspaceModel) {
        this.workspace = workspaceModel;
    }

    protected List<StoreInfo> load() {
        Catalog catalog = GeoServerApplication.get().getCatalog();
        WorkspaceInfo ws = (WorkspaceInfo)this.workspace.getObject();
        List stores = catalog.getStoresByWorkspace(ws, StoreInfo.class);
        Collections.sort(stores, new StoreNameComparator());
        return stores;
    }

    public void detach() {
        super.detach();
        if (this.workspace != null) {
            this.workspace.detach();
        }
    }

    static class StoreNameComparator
    implements Comparator<StoreInfo> {
        StoreNameComparator() {
        }

        @Override
        public int compare(StoreInfo o1, StoreInfo o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

