/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.Repository;

public class ParamInfo
implements Serializable {
    private static final long serialVersionUID = 886996604911751174L;
    private final String name;
    private final String title;
    private boolean password;
    private boolean largeText;
    private Class<?> binding;
    private boolean required;
    private Serializable value;
    private List<Serializable> options;

    public ParamInfo(DataAccessFactory.Param param) {
        List options;
        this.name = param.key;
        this.title = param.title == null ? null : param.title.toString();
        this.password = param.isPassword();
        boolean bl = this.largeText = param.metadata != null && Boolean.TRUE.equals(param.metadata.get("isLargeText"));
        if (Serializable.class.isAssignableFrom(param.type)) {
            this.binding = param.type;
            this.value = (Serializable)param.sample;
        } else if (Repository.class.equals((Object)param.type)) {
            this.binding = param.type;
            this.value = null;
        } else {
            this.binding = String.class;
            this.value = param.sample == null ? null : String.valueOf(param.sample);
        }
        this.required = param.required;
        if (param.metadata != null && (options = (List)param.metadata.get("options")) != null && options.size() > 0) {
            this.options = new ArrayList<Serializable>(options);
            if (Comparable.class.isAssignableFrom(this.binding)) {
                Collections.sort(options);
            }
            if (this.value == null) {
                this.value = (Serializable)options.get(0);
            }
        }
    }

    public List<Serializable> getOptions() {
        return this.options;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isLargeText() {
        return this.largeText;
    }

    public Class<?> getBinding() {
        return this.binding;
    }

    public boolean isRequired() {
        return this.required;
    }
}

