/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.data.store.NamespaceParamModel;
import org.geoserver.web.data.store.ParamInfo;
import org.geoserver.web.data.store.StoreEditPanel;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.DropDownChoiceParamPanel;
import org.geoserver.web.data.store.panel.NamespacePanel;
import org.geoserver.web.data.store.panel.ParamPanel;
import org.geoserver.web.data.store.panel.PasswordParamPanel;
import org.geoserver.web.data.store.panel.TextAreaParamPanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.FileExistsValidator;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.Repository;

public class DefaultDataStoreEditPanel
extends StoreEditPanel {
    private static final long serialVersionUID = -1969433619372747193L;

    public DefaultDataStoreEditPanel(String componentId, Form storeEditForm) {
        super(componentId, storeEditForm);
        DataAccessFactory.Param[] dsParams;
        DataAccessFactory dsFactory;
        IModel model = storeEditForm.getModel();
        DataStoreInfo info = (DataStoreInfo)model.getObject();
        Catalog catalog = this.getCatalog();
        ResourcePool resourcePool = catalog.getResourcePool();
        try {
            dsFactory = resourcePool.getDataStoreFactory(info);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final LinkedHashMap<String, ParamInfo> paramsMetadata = new LinkedHashMap<String, ParamInfo>();
        boolean isNew = null == info.getId();
        for (DataAccessFactory.Param p : dsParams = dsFactory.getParametersInfo()) {
            ParamInfo paramInfo = new ParamInfo(p);
            if (Repository.class.equals(paramInfo.getBinding())) continue;
            paramsMetadata.put(p.key, paramInfo);
            if (!isNew) continue;
            this.applyParamDefault(paramInfo, (StoreInfo)info);
        }
        ArrayList keys = new ArrayList(paramsMetadata.keySet());
        PropertyModel paramsModel = new PropertyModel((Object)model, "connectionParameters");
        ListView paramsList = new ListView("parameters", keys, (IModel)paramsModel){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$paramsModel;
            {
                this.val$paramsModel = iModel;
                super(x0, x1);
            }

            protected void populateItem(ListItem item) {
                String paramName = item.getDefaultModelObjectAsString();
                ParamInfo paramMetadata = (ParamInfo)paramsMetadata.get(paramName);
                Panel inputComponent = DefaultDataStoreEditPanel.this.getInputComponent("parameterPanel", this.val$paramsModel, paramMetadata);
                String description = paramMetadata.getTitle();
                if (description != null) {
                    inputComponent.add(new IBehavior[]{new SimpleAttributeModifier("title", (CharSequence)description)});
                }
                item.add(new Component[]{inputComponent});
            }
        };
        paramsList.setReuseItems(true);
        this.add(new Component[]{paramsList});
    }

    private Panel getInputComponent(String componentId, IModel paramsModel, ParamInfo paramMetadata) {
        Panel parameterPanel;
        String paramName = paramMetadata.getName();
        String paramLabel = paramMetadata.getName();
        boolean required = paramMetadata.isRequired();
        Class<?> binding = paramMetadata.getBinding();
        List<Serializable> options = paramMetadata.getOptions();
        if ("dbtype".equals(paramName) || "filetype".equals(paramName)) {
            MapModel model = new MapModel(paramsModel, paramName);
            TextParamPanel tp = new TextParamPanel(componentId, model, (IModel)new ResourceModel(paramLabel, paramLabel), required, new IValidator[0]);
            tp.setVisible(false);
            parameterPanel = tp;
        } else if ("namespace".equals(paramName)) {
            NamespaceParamModel namespaceModel = new NamespaceParamModel(paramsModel, paramName);
            ResourceModel paramLabelModel = new ResourceModel(paramLabel, paramLabel);
            parameterPanel = new NamespacePanel(componentId, namespaceModel, (IModel)paramLabelModel, true);
        } else if (options != null && options.size() > 0) {
            MapModel valueModel = new MapModel(paramsModel, paramName);
            ResourceModel labelModel = new ResourceModel(paramLabel, paramLabel);
            parameterPanel = new DropDownChoiceParamPanel(componentId, valueModel, (IModel<String>)labelModel, options, required);
        } else if (Boolean.class == binding) {
            parameterPanel = new CheckBoxParamPanel(componentId, new MapModel(paramsModel, paramName), (IModel)new ResourceModel(paramLabel, paramLabel));
        } else if (String.class == binding && paramMetadata.isPassword()) {
            parameterPanel = new PasswordParamPanel(componentId, new MapModel(paramsModel, paramName), (IModel)new ResourceModel(paramLabel, paramLabel), required);
        } else {
            MapModel model = "url".equalsIgnoreCase(paramName) ? new URLModel(paramsModel, paramName) : new MapModel(paramsModel, paramName);
            Panel tp = paramMetadata.isLargeText() ? new TextAreaParamPanel(componentId, model, (IModel)new ResourceModel(paramLabel, paramLabel), required, new IValidator[0]) : new TextParamPanel(componentId, model, (IModel)new ResourceModel(paramLabel, paramLabel), required, new IValidator[0]);
            FormComponent fc = ((ParamPanel)tp).getFormComponent();
            if (paramName.equalsIgnoreCase("url")) {
                fc.add((IValidator)new FileExistsValidator());
            }
            if (!(binding == null || String.class.equals(binding) || File.class.equals(binding) || URL.class.equals(binding) || binding.isArray())) {
                fc.setType(binding);
            }
            parameterPanel = tp;
        }
        return parameterPanel;
    }

    private final class URLModel
    extends MapModel {
        private URLModel(IModel model, String expression) {
            super(model, expression);
        }

        @Override
        public void setObject(Object object) {
            String file = (String)object;
            if (!(file.startsWith("file://") || file.startsWith("file:") || file.startsWith("http://"))) {
                file = "file://" + file;
            }
            super.setObject(file);
        }
    }
}

