/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.layer.LayerPage;
import org.geoserver.web.data.resource.LayerEditTabPanel;
import org.geoserver.web.data.resource.LayerEditTabPanelInfo;
import org.geoserver.web.data.resource.LayerModel;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.data.resource.ResourceConfigurationPanelInfo;
import org.geoserver.web.data.resource.ResourceModel;
import org.geoserver.web.publish.LayerConfigurationPanel;
import org.geoserver.web.publish.LayerConfigurationPanelInfo;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.GeoTools;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.type.Name;
import org.opengis.geometry.Envelope;

public class ResourceConfigurationPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 7870938096047218989L;
    public static final String NAME = "name";
    public static final String WORKSPACE = "wsName";
    private IModel myResourceModel;
    private IModel myLayerModel;
    private boolean isNew;
    private TabbedPanel tabbedPanel;
    private LinkedHashMap<Class<? extends LayerEditTabPanel>, IModel<?>> tabPanelCustomModels;

    public ResourceConfigurationPage(PageParameters parameters) {
        this(parameters.getString(WORKSPACE), parameters.getString(NAME));
    }

    public ResourceConfigurationPage(String workspaceName, String layerName) {
        LayerInfo layer;
        if (workspaceName != null) {
            NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix(workspaceName);
            if (ns == null) {
                throw new RuntimeException("Could not find workspace " + workspaceName);
            }
            String nsURI = ns.getURI();
            layer = this.getCatalog().getLayerByName((Name)new NameImpl(nsURI, layerName));
        } else {
            layer = this.getCatalog().getLayerByName(layerName);
        }
        if (layer == null) {
            this.error((Serializable)((Object)new ParamResourceModel("ResourceConfigurationPage.notFound", (Component)this, layerName).getString()));
            this.setResponsePage(this.returnPage);
            return;
        }
        this.setup(this.getCatalog().getResource(layer.getResource().getId(), ResourceInfo.class), layer);
        this.isNew = false;
        this.initComponents();
    }

    public ResourceConfigurationPage(ResourceInfo info, boolean isNew) {
        this.setup(info, (LayerInfo)this.getCatalog().getLayers(info).get(0));
        this.isNew = isNew;
        this.initComponents();
    }

    public ResourceConfigurationPage(LayerInfo info, boolean isNew) {
        this.setup(info.getResource(), info);
        this.isNew = isNew;
        this.initComponents();
    }

    private void setup(ResourceInfo resource, LayerInfo layer) {
        layer.setResource(resource);
        this.myResourceModel = new CompoundPropertyModel((Object)new ResourceModel(resource));
        this.myLayerModel = new CompoundPropertyModel((Object)new LayerModel(layer));
    }

    private void initComponents() {
        this.returnPageClass = LayerPage.class;
        this.tabPanelCustomModels = new LinkedHashMap();
        this.add(new Component[]{new Label("resourcename", this.getResourceInfo().getPrefixedName())});
        Form theForm = new Form("resource", this.myResourceModel);
        this.add(new Component[]{theForm});
        ArrayList<AbstractTab> tabs = new ArrayList<AbstractTab>();
        tabs.add(new AbstractTab((IModel)new org.apache.wicket.model.ResourceModel("ResourceConfigurationPage.Data")){

            public Panel getPanel(String panelID) {
                return new DataLayerEditTabPanel(panelID, ResourceConfigurationPage.this.myLayerModel);
            }
        });
        this.tabPanelCustomModels.put(DataLayerEditTabPanel.class, null);
        tabs.add(new AbstractTab((IModel)new org.apache.wicket.model.ResourceModel("ResourceConfigurationPage.Publishing")){

            public Panel getPanel(String panelID) {
                return new PublishingLayerEditTabPanel(panelID, ResourceConfigurationPage.this.myLayerModel);
            }
        });
        this.tabPanelCustomModels.put(PublishingLayerEditTabPanel.class, null);
        List<LayerEditTabPanelInfo> tabPanels = this.getGeoServerApplication().getBeansOfType(LayerEditTabPanelInfo.class);
        Collections.sort(tabPanels, new Comparator<LayerEditTabPanelInfo>(){

            @Override
            public int compare(LayerEditTabPanelInfo o1, LayerEditTabPanelInfo o2) {
                Integer order1 = o1.getOrder() >= 0 ? o1.getOrder() : Integer.MAX_VALUE;
                Integer order2 = o2.getOrder() >= 0 ? o2.getOrder() : Integer.MAX_VALUE;
                return order1.compareTo(order2);
            }
        });
        for (LayerEditTabPanelInfo tabPanelInfo : tabPanels) {
            String titleKey = tabPanelInfo.getTitleKey();
            Object titleModel = null;
            titleModel = titleKey != null ? new org.apache.wicket.model.ResourceModel(titleKey) : new Model((Serializable)((Object)tabPanelInfo.getComponentClass().getSimpleName()));
            final Class panelClass = tabPanelInfo.getComponentClass();
            IModel<?> panelCustomModel = tabPanelInfo.createOwnModel((IModel<? extends ResourceInfo>)this.myResourceModel, (IModel<LayerInfo>)this.myLayerModel, this.isNew);
            this.tabPanelCustomModels.put(panelClass, panelCustomModel);
            tabs.add(new AbstractTab((IModel)titleModel){
                private final Class<LayerEditTabPanel> panelType;
                {
                    super(x0);
                    this.panelType = panelClass;
                }

                public Panel getPanel(String panelId) {
                    LayerEditTabPanel tabPanel;
                    IModel panelCustomModel = (IModel)ResourceConfigurationPage.this.tabPanelCustomModels.get(this.panelType);
                    try {
                        tabPanel = panelCustomModel == null ? (LayerEditTabPanel)((Object)panelClass.getConstructor(String.class, IModel.class).newInstance(panelId, ResourceConfigurationPage.this.myLayerModel)) : (LayerEditTabPanel)((Object)panelClass.getConstructor(String.class, IModel.class, IModel.class).newInstance(panelId, ResourceConfigurationPage.this.myLayerModel, panelCustomModel));
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                    return tabPanel;
                }
            });
        }
        this.tabbedPanel = new TabbedPanel("tabs", tabs){

            protected WebMarkupContainer newLink(String linkId, final int index) {
                return new SubmitLink(linkId){

                    public void onSubmit() {
                        this.setSelectedTab(index);
                    }
                };
            }
        };
        theForm.add(new Component[]{this.tabbedPanel});
        theForm.add(new Component[]{this.saveLink()});
        theForm.add(new Component[]{this.cancelLink()});
    }

    public void setSelectedTab(Class<? extends LayerEditTabPanel> selectedTabClass) {
        int selectedTabIndex = new ArrayList<Class<? extends LayerEditTabPanel>>(this.tabPanelCustomModels.keySet()).indexOf(selectedTabClass);
        if (selectedTabIndex > -1) {
            this.tabbedPanel.setSelectedTab(selectedTabIndex);
        }
    }

    private SubmitLink saveLink() {
        return new SubmitLink("save"){

            public void onSubmit() {
                ResourceConfigurationPage.this.doSave();
            }
        };
    }

    protected void doSave() {
        try {
            Catalog catalog = this.getCatalog();
            ResourceInfo resourceInfo = this.getResourceInfo();
            if (this.isNew) {
                if (resourceInfo instanceof CoverageInfo) {
                    CoverageInfo cinfo = (CoverageInfo)resourceInfo;
                    AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)cinfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
                    ReferencedEnvelope bounds = new ReferencedEnvelope((Envelope)reader.getOriginalEnvelope());
                    ProjectionPolicy projectionPolicy = resourceInfo.getProjectionPolicy();
                    if (projectionPolicy != ProjectionPolicy.NONE && bounds != null) {
                        GridGeometry grid = cinfo.getGrid();
                        cinfo.setGrid((GridGeometry)new GridGeometry2D(grid.getGridRange(), grid.getGridToCRS(), resourceInfo.getCRS()));
                    }
                }
                catalog.add(resourceInfo);
                try {
                    catalog.add(this.getLayerInfo());
                }
                catch (IllegalArgumentException e) {
                    catalog.remove(resourceInfo);
                    throw e;
                }
            }
            ResourceInfo oldState = catalog.getResource(resourceInfo.getId(), ResourceInfo.class);
            catalog.save(resourceInfo);
            try {
                LayerInfo layer = this.getLayerInfo();
                layer.setResource(resourceInfo);
                catalog.save(layer);
            }
            catch (IllegalArgumentException e) {
                catalog.save(oldState);
                throw e;
            }
            for (Map.Entry<Class<LayerEditTabPanel>, IModel<?>> e : this.tabPanelCustomModels.entrySet()) {
                Class<? extends LayerEditTabPanel> panelClass = e.getKey();
                IModel<?> customModel = e.getValue();
                if (customModel == null) continue;
                LayerEditTabPanel tabPanel = panelClass.getConstructor(String.class, IModel.class, IModel.class).newInstance("temp", this.myLayerModel, customModel);
                tabPanel.save();
            }
            this.onSuccessfulSave();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error saving layer", e);
            this.error((Serializable)((Object)e.getMessage()));
        }
    }

    private Link cancelLink() {
        return new Link("cancel"){

            public void onClick() {
                ResourceConfigurationPage.this.onCancel();
            }
        };
    }

    private List<ResourceConfigurationPanelInfo> filterResourcePanels(List<ResourceConfigurationPanelInfo> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).canHandle(this.getResourceInfo())) continue;
            list.remove(i);
            --i;
        }
        return list;
    }

    private List<LayerConfigurationPanelInfo> filterLayerPanels(List<LayerConfigurationPanelInfo> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).canHandle(this.getLayerInfo())) continue;
            list.remove(i);
            --i;
        }
        return list;
    }

    public ResourceInfo getResourceInfo() {
        return (ResourceInfo)this.myResourceModel.getObject();
    }

    public LayerInfo getLayerInfo() {
        return (LayerInfo)this.myLayerModel.getObject();
    }

    protected void onSuccessfulSave() {
        this.doReturn();
    }

    protected void onCancel() {
        this.doReturn();
    }

    public void updateResource(ResourceInfo info) {
        this.myResourceModel.setObject((Object)info);
    }

    public void updateLayer(LayerInfo info) {
        this.myLayerModel.setObject((Object)info);
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    private class PublishingLayerEditTabPanel
    extends ListLayerEditTabPanel {
        private static final long serialVersionUID = -6575960326680386479L;

        public PublishingLayerEditTabPanel(String id, IModel model) {
            super(id, model);
        }

        @Override
        public ListView createList(String id) {
            List pubPanels = ResourceConfigurationPage.this.filterLayerPanels(ResourceConfigurationPage.this.getGeoServerApplication().getBeansOfType(LayerConfigurationPanelInfo.class));
            ListView pubPanelList = new ListView(id, pubPanels){

                protected void populateItem(ListItem item) {
                    LayerConfigurationPanelInfo panelInfo = (LayerConfigurationPanelInfo)item.getModelObject();
                    try {
                        LayerConfigurationPanel panel = (LayerConfigurationPanel)((Object)panelInfo.getComponentClass().getConstructor(String.class, IModel.class).newInstance("content", ResourceConfigurationPage.this.myLayerModel));
                        item.add(new Component[]{panel});
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException("Failed to add pluggable layer configuration panels", (Throwable)e);
                    }
                }
            };
            return pubPanelList;
        }
    }

    private class DataLayerEditTabPanel
    extends ListLayerEditTabPanel {
        public DataLayerEditTabPanel(String id, IModel model) {
            super(id, model);
        }

        @Override
        protected ListView createList(String id) {
            List dataPanels = ResourceConfigurationPage.this.filterResourcePanels(ResourceConfigurationPage.this.getGeoServerApplication().getBeansOfType(ResourceConfigurationPanelInfo.class));
            ListView dataPanelList = new ListView(id, dataPanels){

                protected void populateItem(ListItem item) {
                    ResourceConfigurationPanelInfo panelInfo = (ResourceConfigurationPanelInfo)item.getModelObject();
                    try {
                        Class componentClass = panelInfo.getComponentClass();
                        Constructor constructor = componentClass.getConstructor(String.class, IModel.class);
                        ResourceConfigurationPanel panel = (ResourceConfigurationPanel)((Object)constructor.newInstance("content", ResourceConfigurationPage.this.myResourceModel));
                        item.add(new Component[]{panel});
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException("Failed to add pluggable resource configuration panels", (Throwable)e);
                    }
                }
            };
            return dataPanelList;
        }
    }

    private abstract class ListLayerEditTabPanel
    extends LayerEditTabPanel {
        public ListLayerEditTabPanel(String id, IModel model) {
            super(id, model);
            ListView list = this.createList("theList");
            list.setReuseItems(true);
            this.add(new Component[]{list});
        }

        protected abstract ListView createList(String var1);
    }
}

