/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.web.data.resource.PeriodEditor;
import org.geoserver.web.wicket.ParamResourceModel;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.type.PropertyDescriptor;

public class DimensionEditor
extends FormComponentPanel<DimensionInfo> {
    List<DimensionPresentation> PRESENTATION_MODES = Arrays.asList(DimensionPresentation.values());
    private CheckBox enabled;
    private DropDownChoice<String> attribute;
    private DropDownChoice<String> endAttribute;
    private DropDownChoice<DimensionPresentation> presentation;
    private PeriodEditor resTime;
    private TextField<BigDecimal> resElevation;
    boolean time;

    public DimensionEditor(String id, IModel<DimensionInfo> model, ResourceInfo resource, Class type) {
        super(id, model);
        final WebMarkupContainer configsContainer = new WebMarkupContainer("configContainer");
        configsContainer.setOutputMarkupId(true);
        this.add(new Component[]{configsContainer});
        final WebMarkupContainer configs = new WebMarkupContainer("configs");
        configs.setOutputMarkupId(true);
        configs.setVisible(((DimensionInfo)this.getModelObject()).isEnabled());
        configsContainer.add(new Component[]{configs});
        PropertyModel enabledModel = new PropertyModel(model, "enabled");
        this.enabled = new CheckBox("enabled", (IModel)enabledModel);
        this.add(new Component[]{this.enabled});
        this.enabled.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onclick"){

            protected void onUpdate(AjaxRequestTarget target) {
                Boolean visile = (Boolean)DimensionEditor.this.enabled.getModelObject();
                configs.setVisible(visile.booleanValue());
                target.addComponent((Component)configsContainer);
            }
        }});
        Label noAttributeMessage = new Label("noAttributeMsg", "");
        this.add(new Component[]{noAttributeMessage});
        WebMarkupContainer attContainer = new WebMarkupContainer("attributeContainer");
        configs.add(new Component[]{attContainer});
        List<String> attributes = this.getAttributesOfType(resource, type);
        this.attribute = new DropDownChoice("attribute", (IModel)new PropertyModel(model, "attribute"), attributes);
        this.attribute.setOutputMarkupId(true);
        this.attribute.setRequired(true);
        attContainer.add(new Component[]{this.attribute});
        ArrayList<String> endAttributes = new ArrayList<String>(attributes);
        endAttributes.add(0, "-");
        this.endAttribute = new DropDownChoice("endAttribute", (IModel)new PropertyModel(model, "endAttribute"), endAttributes);
        this.endAttribute.setOutputMarkupId(true);
        this.endAttribute.setRequired(false);
        attContainer.add(new Component[]{this.endAttribute});
        if (resource instanceof FeatureTypeInfo) {
            if (attributes.isEmpty()) {
                this.disableDimension(type, configs, noAttributeMessage);
            } else {
                noAttributeMessage.setVisible(false);
            }
        } else if (resource instanceof CoverageInfo) {
            attContainer.setVisible(false);
            this.attribute.setRequired(false);
            try {
                String time;
                GridCoverageReader reader = ((CoverageInfo)resource).getGridCoverageReader(null, null);
                if (Number.class.isAssignableFrom(type)) {
                    String elev = reader.getMetadataValue("HAS_ELEVATION_DOMAIN");
                    if (!Boolean.parseBoolean(elev)) {
                        this.disableDimension(type, configs, noAttributeMessage);
                    }
                } else if (Date.class.isAssignableFrom(type) && !Boolean.parseBoolean(time = reader.getMetadataValue("HAS_TIME_DOMAIN"))) {
                    this.disableDimension(type, configs, noAttributeMessage);
                }
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        final WebMarkupContainer resContainer = new WebMarkupContainer("resolutionContainer");
        resContainer.setOutputMarkupId(true);
        configs.add(new Component[]{resContainer});
        final WebMarkupContainer resolutions = new WebMarkupContainer("resolutions");
        resolutions.setVisible(((DimensionInfo)model.getObject()).getPresentation() == DimensionPresentation.DISCRETE_INTERVAL);
        resolutions.setOutputMarkupId(true);
        resContainer.add(new Component[]{resolutions});
        this.presentation = new DropDownChoice("presentation", (IModel)new PropertyModel(model, "presentation"), this.PRESENTATION_MODES, (IChoiceRenderer)new PresentationModeRenderer());
        configs.add(new Component[]{this.presentation});
        this.presentation.setRequired(true);
        this.presentation.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean visible = DimensionEditor.this.presentation.getModelObject() == DimensionPresentation.DISCRETE_INTERVAL;
                resolutions.setVisible(visible);
                target.addComponent((Component)resContainer);
            }
        }});
        PropertyModel rmodel = new PropertyModel(model, "resolution");
        this.resTime = new PeriodEditor("resTime", (IModel<BigDecimal>)rmodel);
        resolutions.add(new Component[]{this.resTime});
        this.resElevation = new TextField("resElevation", (IModel)rmodel);
        resolutions.add(new Component[]{this.resElevation});
        this.time = Date.class.isAssignableFrom(type);
        if (this.time) {
            this.resElevation.setVisible(false);
            this.resTime.setRequired(true);
        } else {
            this.resTime.setVisible(false);
            this.resElevation.setRequired(true);
        }
    }

    private void disableDimension(Class type, WebMarkupContainer configs, Label noAttributeMessage) {
        this.enabled.setEnabled(false);
        this.enabled.setModelObject((Object)false);
        configs.setVisible(false);
        ParamResourceModel typeName = new ParamResourceModel("AttributeType." + type.getSimpleName(), null, new Object[0]);
        ParamResourceModel error = new ParamResourceModel("missingAttribute", (Component)this, typeName.getString());
        noAttributeMessage.setDefaultModelObject((Object)error.getString());
    }

    public boolean processChildren() {
        return true;
    }

    protected void convertInput() {
        if (!((Boolean)this.enabled.getModelObject()).booleanValue()) {
            this.setConvertedInput(new DimensionInfoImpl());
        } else {
            DimensionInfoImpl info = new DimensionInfoImpl();
            info.setEnabled(true);
            this.attribute.processInput();
            this.endAttribute.processInput();
            info.setAttribute((String)this.attribute.getModelObject());
            String endAttributeValue = (String)this.endAttribute.getModelObject();
            if ("-".equals(endAttributeValue)) {
                endAttributeValue = null;
            }
            info.setEndAttribute(endAttributeValue);
            info.setPresentation((DimensionPresentation)this.presentation.getModelObject());
            if (info.getPresentation() == DimensionPresentation.DISCRETE_INTERVAL) {
                if (this.time) {
                    this.resTime.processInput();
                    info.setResolution((BigDecimal)this.resTime.getModelObject());
                } else {
                    this.resElevation.processInput();
                    info.setResolution((BigDecimal)this.resElevation.getModelObject());
                }
            }
            this.setConvertedInput(info);
        }
    }

    List<String> getAttributesOfType(ResourceInfo resource, Class<?> type) {
        ArrayList<String> result = new ArrayList<String>();
        if (resource instanceof FeatureTypeInfo) {
            try {
                FeatureTypeInfo ft = (FeatureTypeInfo)resource;
                for (PropertyDescriptor pd : ft.getFeatureType().getDescriptors()) {
                    if (!type.isAssignableFrom(pd.getType().getBinding())) continue;
                    result.add(pd.getName().getLocalPart());
                }
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        return result;
    }

    public class PresentationModeRenderer
    implements IChoiceRenderer<DimensionPresentation> {
        public Object getDisplayValue(DimensionPresentation object) {
            return new ParamResourceModel(object.name(), (Component)DimensionEditor.this, new Object[0]).getString();
        }

        public String getIdValue(DimensionPresentation object, int index) {
            return String.valueOf(object.ordinal());
        }
    }
}

