/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.web.data.layergroup.AbstractLayerGroupPage;
import org.geoserver.web.data.layergroup.LayerGroupPage;
import org.geoserver.web.wicket.ParamResourceModel;

public class LayerGroupEditPage
extends AbstractLayerGroupPage {
    public static final String GROUP = "group";
    public static final String WORKSPACE = "workspace";

    public LayerGroupEditPage(PageParameters parameters) {
        LayerGroupInfo lg;
        String groupName = parameters.getString(GROUP);
        String wsName = parameters.getString(WORKSPACE);
        LayerGroupInfo layerGroupInfo = lg = wsName != null ? this.getCatalog().getLayerGroupByName(wsName, groupName) : this.getCatalog().getLayerGroupByName(groupName);
        if (lg == null) {
            this.error((Serializable)((Object)new ParamResourceModel("LayerGroupEditPage.notFound", (Component)this, groupName).getString()));
            this.doReturn(LayerGroupPage.class);
            return;
        }
        this.initUI(lg);
        if (!this.isAuthenticatedAsAdmin()) {
            Form f = (Form)this.get("form");
            if (lg.getWorkspace() == null) {
                f.visitChildren((Component.IVisitor)new Component.IVisitor<Component>(){

                    public Object component(Component c) {
                        if (!(c instanceof AbstractLink) || !"cancel".equals(c.getId())) {
                            c.setEnabled(false);
                        }
                        return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                    }
                });
                f.get("save").setVisible(false);
                this.info(new StringResourceModel("globalLayerGroupReadOnly", (Component)this, null).getString());
            }
            f.get(WORKSPACE).setEnabled(false);
        }
    }

    @Override
    protected void onSubmit() {
        LayerGroupInfo lg = (LayerGroupInfo)this.lgModel.getObject();
        this.getCatalog().save(lg);
        this.doReturn();
    }
}

