/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.layer.LayerDetachableModel;
import org.geoserver.web.data.layergroup.LayerGroupDetachableModel;
import org.geoserver.web.data.layergroup.LayerGroupEntry;
import org.geoserver.web.data.layergroup.LayerGroupEntryPanel;
import org.geoserver.web.data.layergroup.LayerGroupPage;
import org.geoserver.web.data.style.StyleDetachableModel;
import org.geoserver.web.data.workspace.WorkspaceChoiceRenderer;
import org.geoserver.web.data.workspace.WorkspacesModel;
import org.geoserver.web.publish.LayerGroupConfigurationPanel;
import org.geoserver.web.publish.LayerGroupConfigurationPanelInfo;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractLayerGroupPage
extends GeoServerSecuredPage {
    public static final String GROUP = "group";
    IModel<LayerGroupInfo> lgModel;
    EnvelopePanel envelopePanel;
    LayerGroupEntryPanel lgEntryPanel;
    String layerGroupId;
    private ListView<LayerGroupConfigurationPanelInfo> extensionPanels;

    protected void initUI(LayerGroupInfo layerGroup) {
        this.returnPageClass = LayerGroupPage.class;
        this.lgModel = new LayerGroupDetachableModel(layerGroup);
        this.layerGroupId = layerGroup.getId();
        Form form = new Form("form", (IModel)new CompoundPropertyModel(this.lgModel));
        this.add(new Component[]{form});
        TextField name = new TextField("name");
        name.setRequired(true);
        form.add(new Component[]{name});
        DropDownChoice wsChoice = new DropDownChoice("workspace", (IModel)new WorkspacesModel(), (IChoiceRenderer)new WorkspaceChoiceRenderer());
        wsChoice.setNullValid(true);
        if (!this.isAuthenticatedAsAdmin()) {
            wsChoice.setNullValid(false);
            wsChoice.setRequired(true);
        }
        form.add(new Component[]{wsChoice});
        Component[] componentArray = new Component[1];
        this.envelopePanel = new EnvelopePanel("bounds");
        componentArray[0] = this.envelopePanel;
        form.add(componentArray);
        this.envelopePanel.setRequired(true);
        this.envelopePanel.setCRSFieldVisible(true);
        this.envelopePanel.setOutputMarkupId(true);
        form.add(new Component[]{new GeoServerAjaxFormLink("generateBounds"){

            @Override
            public void onClick(AjaxRequestTarget target, Form form) {
                LayerGroupInfo lg = AbstractLayerGroupPage.this.getCatalog().getFactory().createLayerGroup();
                for (LayerGroupEntry entry : AbstractLayerGroupPage.this.lgEntryPanel.getEntries()) {
                    lg.getLayers().add(entry.getLayer());
                    lg.getStyles().add(entry.getStyle());
                }
                try {
                    CoordinateReferenceSystem crs = AbstractLayerGroupPage.this.envelopePanel.getCoordinateReferenceSystem();
                    if (crs != null) {
                        new CatalogBuilder(AbstractLayerGroupPage.this.getCatalog()).calculateLayerGroupBounds(lg, crs);
                    } else {
                        new CatalogBuilder(AbstractLayerGroupPage.this.getCatalog()).calculateLayerGroupBounds(lg);
                    }
                    AbstractLayerGroupPage.this.envelopePanel.setModelObject(lg.getBounds());
                    target.addComponent((Component)AbstractLayerGroupPage.this.envelopePanel);
                }
                catch (Exception e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        }});
        Component[] componentArray2 = new Component[1];
        this.lgEntryPanel = new LayerGroupEntryPanel("layers", layerGroup);
        componentArray2[0] = this.lgEntryPanel;
        form.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.extensionPanels = this.extensionPanels();
        componentArray3[0] = this.extensionPanels;
        form.add(componentArray3);
        form.add(new Component[]{this.saveLink()});
        form.add(new Component[]{this.cancelLink()});
    }

    private ListView<LayerGroupConfigurationPanelInfo> extensionPanels() {
        GeoServerApplication gsapp = this.getGeoServerApplication();
        List<LayerGroupConfigurationPanelInfo> extensions = gsapp.getBeansOfType(LayerGroupConfigurationPanelInfo.class);
        ListView<LayerGroupConfigurationPanelInfo> list = new ListView<LayerGroupConfigurationPanelInfo>("contributedPanels", extensions){

            protected void populateItem(ListItem<LayerGroupConfigurationPanelInfo> item) {
                LayerGroupConfigurationPanelInfo panelInfo = (LayerGroupConfigurationPanelInfo)item.getModelObject();
                try {
                    Class componentClass = panelInfo.getComponentClass();
                    Constructor constructor = componentClass.getConstructor(String.class, IModel.class);
                    LayerGroupConfigurationPanel panel = (LayerGroupConfigurationPanel)((Object)constructor.newInstance("content", AbstractLayerGroupPage.this.lgModel));
                    item.add(new Component[]{panel});
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Failed to add pluggable layergroup configuration panels", (Throwable)e);
                }
            }
        };
        return list;
    }

    private Component cancelLink() {
        return new AjaxLink<String>("cancel"){

            public void onClick(AjaxRequestTarget target) {
                AbstractLayerGroupPage.this.doReturn();
            }
        };
    }

    private SubmitLink saveLink() {
        return new SubmitLink("save"){

            public void onSubmit() {
                if (AbstractLayerGroupPage.this.lgEntryPanel.getEntries().size() == 0) {
                    this.error((Serializable)((Object)((String)new ParamResourceModel("oneLayerMinimum", (Component)this.getPage(), new Object[0]).getObject())));
                    return;
                }
                LayerGroupInfo lg = (LayerGroupInfo)AbstractLayerGroupPage.this.lgModel.getObject();
                lg.getLayers().clear();
                lg.getStyles().clear();
                for (LayerGroupEntry entry : AbstractLayerGroupPage.this.lgEntryPanel.getEntries()) {
                    lg.getLayers().add(entry.getLayer());
                    lg.getStyles().add(entry.getStyle());
                }
                try {
                    AbstractLayerGroupPage.this.save();
                }
                catch (Exception e) {
                    this.error(e);
                    LOGGER.log(Level.WARNING, "Error adding/modifying layer group.", e);
                }
            }
        };
    }

    private final void save() {
        this.onSubmit();
        this.extensionPanels.visitChildren(LayerGroupConfigurationPanel.class, (Component.IVisitor)new Component.IVisitor<LayerGroupConfigurationPanel>(){

            public Object component(LayerGroupConfigurationPanel extensionPanel) {
                extensionPanel.save();
                return CONTINUE_TRAVERSAL;
            }
        });
    }

    protected abstract void onSubmit();

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    class GroupNameValidator
    extends AbstractValidator {
        GroupNameValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            String name = (String)validatable.getValue();
            LayerGroupInfo other = AbstractLayerGroupPage.this.getCatalog().getLayerGroupByName(name);
            if (!(other == null || AbstractLayerGroupPage.this.layerGroupId != null && other.getId().equals(AbstractLayerGroupPage.this.layerGroupId))) {
                this.error(validatable, "duplicateGroupNameError", Collections.singletonMap("name", name));
            }
        }
    }

    static abstract class LayerListPanel
    extends GeoServerTablePanel<LayerInfo> {
        static GeoServerDataProvider.Property<LayerInfo> NAME = new GeoServerDataProvider.BeanProperty<LayerInfo>("name", "name");
        static GeoServerDataProvider.Property<LayerInfo> STORE = new GeoServerDataProvider.BeanProperty<LayerInfo>("store", "resource.store.name");
        static GeoServerDataProvider.Property<LayerInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty<LayerInfo>("workspace", "resource.store.workspace.name");

        LayerListPanel(String id) {
            super(id, new GeoServerDataProvider<LayerInfo>(){

                @Override
                protected List<LayerInfo> getItems() {
                    return this.getCatalog().getLayers();
                }

                @Override
                protected List<GeoServerDataProvider.Property<LayerInfo>> getProperties() {
                    return Arrays.asList(NAME, STORE, WORKSPACE);
                }

                @Override
                public IModel newModel(Object object) {
                    return new LayerDetachableModel((LayerInfo)object);
                }
            });
            this.getTopPager().setVisible(false);
        }

        @Override
        protected Component getComponentForProperty(String id, final IModel itemModel, GeoServerDataProvider.Property<LayerInfo> property) {
            IModel model = property.getModel(itemModel);
            if (NAME == property) {
                return new SimpleAjaxLink(id, model){

                    @Override
                    protected void onClick(AjaxRequestTarget target) {
                        LayerInfo layer = (LayerInfo)itemModel.getObject();
                        LayerListPanel.this.handleLayer(layer, target);
                    }
                };
            }
            return new Label(id, model);
        }

        protected void handleLayer(LayerInfo layer, AjaxRequestTarget target) {
        }
    }

    static abstract class StyleListPanel
    extends GeoServerTablePanel<StyleInfo> {
        static GeoServerDataProvider.Property<StyleInfo> NAME = new GeoServerDataProvider.BeanProperty<StyleInfo>("name", "name");

        public StyleListPanel(String id) {
            super(id, new GeoServerDataProvider<StyleInfo>(){

                @Override
                protected List<StyleInfo> getItems() {
                    return this.getCatalog().getStyles();
                }

                @Override
                protected List<GeoServerDataProvider.Property<StyleInfo>> getProperties() {
                    return Arrays.asList(NAME);
                }

                @Override
                public IModel newModel(Object object) {
                    return new StyleDetachableModel((StyleInfo)object);
                }
            });
            this.getTopPager().setVisible(false);
        }

        @Override
        protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<StyleInfo> property) {
            final StyleInfo style = (StyleInfo)itemModel.getObject();
            if (property == NAME) {
                return new SimpleAjaxLink(id, NAME.getModel(itemModel)){

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        StyleListPanel.this.handleStyle(style, target);
                    }
                };
            }
            return null;
        }

        protected abstract void handleStyle(StyleInfo var1, AjaxRequestTarget var2);
    }
}

