/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.importer.WMSLayerImporterPage;
import org.geoserver.web.data.layer.NewFeatureTypePage;
import org.geoserver.web.data.layer.NewLayerPageProvider;
import org.geoserver.web.data.layer.Resource;
import org.geoserver.web.data.layer.SQLViewNewPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.data.store.StoreListChoiceRenderer;
import org.geoserver.web.data.store.StoreListModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geotools.data.DataAccess;
import org.geotools.data.wms.WebMapServer;
import org.geotools.jdbc.JDBCDataStore;

public class NewLayerPage
extends GeoServerSecuredPage {
    String storeId;
    private NewLayerPageProvider provider;
    private GeoServerTablePanel<Resource> layers;
    private WebMarkupContainer selectLayersContainer;
    private WebMarkupContainer selectLayers;
    private Label storeName;
    private WebMarkupContainer createTypeContainer;
    private WebMarkupContainer createSQLViewContainer;
    private WebMarkupContainer createWMSLayerImportContainer;

    public NewLayerPage() {
        this(null);
    }

    public NewLayerPage(String storeId) {
        StoreInfo store;
        this.storeId = storeId;
        Form selector = new Form("selector");
        selector.add(new Component[]{this.storesDropDown()});
        selector.setVisible(storeId == null);
        this.add(new Component[]{selector});
        this.selectLayersContainer = new WebMarkupContainer("selectLayersContainer");
        this.selectLayersContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.selectLayersContainer});
        this.selectLayers = new WebMarkupContainer("selectLayers");
        this.selectLayers.setVisible(storeId != null);
        this.selectLayersContainer.add(new Component[]{this.selectLayers});
        Component[] componentArray = new Component[1];
        this.storeName = new Label("storeName", (IModel)new Model());
        componentArray[0] = this.storeName;
        this.selectLayers.add(componentArray);
        if (storeId != null) {
            store = this.getCatalog().getStore(storeId, StoreInfo.class);
            this.storeName.setDefaultModelObject((Object)store.getName());
        }
        this.provider = new NewLayerPageProvider();
        this.provider.setStoreId(storeId);
        this.provider.setShowPublished(true);
        this.layers = new GeoServerTablePanel<Resource>("layers", (GeoServerDataProvider)this.provider){

            @Override
            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<Resource> property) {
                if (property == NewLayerPageProvider.NAME) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property == NewLayerPageProvider.PUBLISHED) {
                    Resource resource = (Resource)itemModel.getObject();
                    CatalogIconFactory icons = CatalogIconFactory.get();
                    if (resource.isPublished()) {
                        ResourceReference icon = icons.getEnabledIcon();
                        Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)NewLayerPage.this);
                        f.add(new Component[]{new Image("layerIcon", icon)});
                        return f;
                    }
                    return new Label(id);
                }
                if (property == NewLayerPageProvider.ACTION) {
                    Resource resource = (Resource)itemModel.getObject();
                    if (resource.isPublished()) {
                        return NewLayerPage.this.resourceChooserLink(id, itemModel, (IModel)new ParamResourceModel("publishAgain", (Component)this, new Object[0]));
                    }
                    return NewLayerPage.this.resourceChooserLink(id, itemModel, (IModel)new ParamResourceModel("publish", (Component)this, new Object[0]));
                }
                throw new IllegalArgumentException("Don't know of property " + property.getName());
            }
        };
        this.layers.setFilterVisible(true);
        this.selectLayers.add(new Component[]{this.layers});
        this.createTypeContainer = new WebMarkupContainer("createTypeContainer");
        this.createTypeContainer.setVisible(false);
        this.createTypeContainer.add(new Component[]{this.newFeatureTypeLink()});
        this.selectLayersContainer.add(new Component[]{this.createTypeContainer});
        this.createSQLViewContainer = new WebMarkupContainer("createSQLViewContainer");
        this.createSQLViewContainer.setVisible(false);
        this.createSQLViewContainer.add(new Component[]{this.newSQLViewLink()});
        this.selectLayersContainer.add(new Component[]{this.createSQLViewContainer});
        this.createWMSLayerImportContainer = new WebMarkupContainer("createWMSLayerImportContainer");
        this.createWMSLayerImportContainer.setVisible(false);
        this.createWMSLayerImportContainer.add(new Component[]{this.newWMSImportLink()});
        this.selectLayersContainer.add(new Component[]{this.createWMSLayerImportContainer});
        if (storeId != null) {
            store = this.getCatalog().getStore(storeId, StoreInfo.class);
            this.updateSpecialFunctionPanels(store);
        }
    }

    Component newFeatureTypeLink() {
        return new AjaxLink("createFeatureType"){

            public void onClick(AjaxRequestTarget target) {
                DataStoreInfo ds = (DataStoreInfo)NewLayerPage.this.getCatalog().getStore(NewLayerPage.this.storeId, DataStoreInfo.class);
                PageParameters pp = new PageParameters("wsName=" + ds.getWorkspace().getName() + ",storeName=" + ds.getName());
                this.setResponsePage(NewFeatureTypePage.class, pp);
            }
        };
    }

    Component newSQLViewLink() {
        return new AjaxLink("createSQLView"){

            public void onClick(AjaxRequestTarget target) {
                DataStoreInfo ds = (DataStoreInfo)NewLayerPage.this.getCatalog().getStore(NewLayerPage.this.storeId, DataStoreInfo.class);
                PageParameters pp = new PageParameters("wsName=" + ds.getWorkspace().getName() + ",storeName=" + ds.getName());
                this.setResponsePage(SQLViewNewPage.class, pp);
            }
        };
    }

    Component newWMSImportLink() {
        return new AjaxLink("createWMSImport"){

            public void onClick(AjaxRequestTarget target) {
                WMSStoreInfo wms = (WMSStoreInfo)NewLayerPage.this.getCatalog().getStore(NewLayerPage.this.storeId, WMSStoreInfo.class);
                PageParameters pp = new PageParameters("storeId=" + NewLayerPage.this.storeId);
                this.setResponsePage(WMSLayerImporterPage.class, pp);
            }
        };
    }

    private DropDownChoice storesDropDown() {
        final DropDownChoice stores = new DropDownChoice("storesDropDown", (IModel)new Model(), (IModel)new StoreListModel(), (IChoiceRenderer)new StoreListChoiceRenderer());
        stores.setOutputMarkupId(true);
        stores.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                if (stores.getModelObject() != null) {
                    StoreInfo store = (StoreInfo)stores.getModelObject();
                    NewLayerPage.this.storeId = store.getId();
                    NewLayerPage.this.provider.setStoreId(store.getId());
                    NewLayerPage.this.storeName.setDefaultModelObject((Object)store.getName());
                    NewLayerPage.this.selectLayers.setVisible(true);
                    try {
                        NewLayerPage.this.provider.getItems();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error retrieving layers for the specified store", e);
                        NewLayerPage.this.error((Serializable)((Object)e.getMessage()));
                        NewLayerPage.this.selectLayers.setVisible(false);
                    }
                    NewLayerPage.this.updateSpecialFunctionPanels(store);
                } else {
                    NewLayerPage.this.selectLayers.setVisible(false);
                    NewLayerPage.this.createTypeContainer.setVisible(false);
                }
                target.addComponent((Component)NewLayerPage.this.selectLayersContainer);
                target.addComponent((Component)NewLayerPage.this.feedbackPanel);
            }
        }});
        return stores;
    }

    SimpleAjaxLink resourceChooserLink(String id, IModel itemModel, IModel label) {
        return new SimpleAjaxLink(id, itemModel, label){

            @Override
            protected void onClick(AjaxRequestTarget target) {
                Resource resource = (Resource)this.getDefaultModelObject();
                this.setResponsePage((Page)new ResourceConfigurationPage(NewLayerPage.this.buildLayerInfo(resource), true));
            }
        };
    }

    void updateSpecialFunctionPanels(StoreInfo store) {
        this.createTypeContainer.setVisible(store instanceof DataStoreInfo);
        this.createSQLViewContainer.setVisible(false);
        if (store instanceof DataStoreInfo) {
            try {
                DataAccess da = ((DataStoreInfo)store).getDataStore(null);
                this.createSQLViewContainer.setVisible(da instanceof JDBCDataStore);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.createWMSLayerImportContainer.setVisible(false);
        if (store instanceof WMSStoreInfo) {
            try {
                WebMapServer wms = ((WMSStoreInfo)store).getWebMapServer(null);
                this.createWMSLayerImportContainer.setVisible(wms != null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    LayerInfo buildLayerInfo(Resource resource) {
        Catalog catalog = this.getCatalog();
        StoreInfo store = catalog.getStore(this.getSelectedStoreId(), StoreInfo.class);
        try {
            CatalogBuilder builder = new CatalogBuilder(catalog);
            builder.setStore(store);
            if (store instanceof CoverageStoreInfo) {
                CoverageInfo ci = builder.buildCoverage();
                return builder.buildLayer(ci);
            }
            if (store instanceof DataStoreInfo) {
                FeatureTypeInfo fti = builder.buildFeatureType(resource.getName());
                return builder.buildLayer(fti);
            }
            if (store instanceof WMSStoreInfo) {
                WMSLayerInfo wli = builder.buildWMSLayer(resource.getLocalName());
                return builder.buildLayer(wli);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while building the resources for the configuration page", e);
        }
        if (store == null) {
            throw new IllegalArgumentException("Store is missing from configuration!");
        }
        throw new IllegalArgumentException("Don't know how to deal with this store " + store);
    }

    String getSelectedStoreId() {
        return this.provider.getStoreId();
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

