/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.importer;

import java.io.Serializable;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;

public class LayerResource
implements Comparable<LayerResource>,
Serializable {
    String name;
    String uri;
    LayerStatus status = LayerStatus.NEW;
    String error;

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public LayerResource(Name name) {
        this.name = name.getLocalPart();
        this.uri = name.getURI();
    }

    public String getLocalName() {
        return this.name;
    }

    public Name getName() {
        return new NameImpl(this.uri, this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayerResource other = (LayerResource)obj;
        if (this.error == null ? other.error != null : !this.error.equals(other.error)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    @Override
    public int compareTo(LayerResource o) {
        if (this.status.compareTo(o.status) != 0) {
            return this.status.compareTo(o.status);
        }
        return this.name.compareTo(o.name);
    }

    public LayerStatus getStatus() {
        return this.status;
    }

    public void setStatus(LayerStatus status) {
        this.status = status;
    }

    public String toString() {
        return this.name + "(" + (Object)((Object)this.status) + ")";
    }

    static enum LayerStatus {
        ERROR,
        NEWLY_PUBLISHED,
        UPDATED,
        NEW,
        PUBLISHED;

    }
}

