/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.CascadeRemovalReporter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;

public class ConfirmRemovalPanel
extends Panel {
    List<? extends CatalogInfo> roots;

    public ConfirmRemovalPanel(String id, CatalogInfo ... roots) {
        this(id, Arrays.asList(roots));
    }

    public ConfirmRemovalPanel(String id, List<? extends CatalogInfo> roots) {
        super(id);
        this.roots = roots;
        HashMap<CatalogInfo, StringResourceModel> notRemoved = new HashMap<CatalogInfo, StringResourceModel>();
        Catalog catalog = GeoServerApplication.get().getCatalog();
        CascadeRemovalReporter visitor = new CascadeRemovalReporter(catalog);
        Iterator<? extends CatalogInfo> i = roots.iterator();
        while (i.hasNext()) {
            CatalogInfo root = i.next();
            StringResourceModel reason = this.canRemove(root);
            if (reason != null) {
                notRemoved.put(root, reason);
                i.remove();
                continue;
            }
            root.accept((CatalogVisitor)visitor);
        }
        visitor.removeAll(roots);
        WebMarkupContainer root = new WebMarkupContainer("rootObjects");
        root.add(new Component[]{new Label("rootObjectNames", this.names(roots))});
        root.setVisible(!roots.isEmpty());
        this.add(new Component[]{root});
        WebMarkupContainer nr = new WebMarkupContainer("notRemovedObjects");
        nr.setVisible(!notRemoved.isEmpty());
        nr.add(new Component[]{this.notRemovedList(notRemoved)});
        this.add(new Component[]{nr});
        WebMarkupContainer removed = new WebMarkupContainer("removedObjects");
        List cascaded = visitor.getObjects(CatalogInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE});
        Iterator it = cascaded.iterator();
        while (it.hasNext()) {
            CatalogInfo catalogInfo = (CatalogInfo)it.next();
            if (!(catalogInfo instanceof ResourceInfo)) continue;
            it.remove();
        }
        removed.setVisible(cascaded.size() > 0);
        this.add(new Component[]{removed});
        WebMarkupContainer wsr = new WebMarkupContainer("workspacesRemoved");
        removed.add(new Component[]{wsr});
        List workspaces = visitor.getObjects(WorkspaceInfo.class, new CascadeRemovalReporter.ModificationType[0]);
        if (workspaces.size() == 0) {
            wsr.setVisible(false);
        }
        wsr.add(new Component[]{new Label("workspaces", this.names(workspaces))});
        WebMarkupContainer str = new WebMarkupContainer("storesRemoved");
        removed.add(new Component[]{str});
        List stores = visitor.getObjects(StoreInfo.class, new CascadeRemovalReporter.ModificationType[0]);
        if (stores.size() == 0) {
            str.setVisible(false);
        }
        str.add(new Component[]{new Label("stores", this.names(stores))});
        WebMarkupContainer lar = new WebMarkupContainer("layersRemoved");
        removed.add(new Component[]{lar});
        List layers = visitor.getObjects(LayerInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE});
        if (layers.size() == 0) {
            lar.setVisible(false);
        }
        lar.add(new Component[]{new Label("layers", this.names(layers))});
        WebMarkupContainer grr = new WebMarkupContainer("groupsRemoved");
        removed.add(new Component[]{grr});
        List groups = visitor.getObjects(LayerGroupInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE});
        if (groups.size() == 0) {
            grr.setVisible(false);
        }
        grr.add(new Component[]{new Label("groups", this.names(groups))});
        WebMarkupContainer modified = new WebMarkupContainer("modifiedObjects");
        modified.setVisible(visitor.getObjects(null, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.EXTRA_STYLE_REMOVED, CascadeRemovalReporter.ModificationType.GROUP_CHANGED, CascadeRemovalReporter.ModificationType.STYLE_RESET}).size() > 0);
        this.add(new Component[]{modified});
        WebMarkupContainer lam = new WebMarkupContainer("layersModified");
        modified.add(new Component[]{lam});
        layers = visitor.getObjects(LayerInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.STYLE_RESET, CascadeRemovalReporter.ModificationType.EXTRA_STYLE_REMOVED});
        if (layers.size() == 0) {
            lam.setVisible(false);
        }
        lam.add(new Component[]{new Label("layers", this.names(layers))});
        WebMarkupContainer grm = new WebMarkupContainer("groupsModified");
        modified.add(new Component[]{grm});
        groups = visitor.getObjects(LayerGroupInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.GROUP_CHANGED});
        if (groups.size() == 0) {
            grm.setVisible(false);
        }
        grm.add(new Component[]{new Label("groups", this.names(groups))});
    }

    public List<? extends CatalogInfo> getRoots() {
        return this.roots;
    }

    String names(List objects) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < objects.size(); ++i) {
            sb.append(this.name(objects.get(i)));
            if (i >= objects.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    String name(Object object) {
        try {
            return BeanUtils.getProperty((Object)object, (String)"name");
        }
        catch (Exception e) {
            throw new RuntimeException("A catalog object that does not have a 'name' property has been used, this is unexpected", e);
        }
    }

    ListView notRemovedList(final Map<CatalogInfo, StringResourceModel> notRemoved) {
        ArrayList<CatalogInfo> items = new ArrayList<CatalogInfo>(notRemoved.keySet());
        ListView lv = new ListView("notRemovedList", items){

            protected void populateItem(ListItem item) {
                CatalogInfo object = (CatalogInfo)item.getModelObject();
                StringResourceModel reason = (StringResourceModel)notRemoved.get(object);
                item.add(new Component[]{new Label("name", ConfirmRemovalPanel.this.name(object))});
                item.add(new Component[]{new Label("reason", (IModel)reason)});
            }
        };
        return lv;
    }

    protected StringResourceModel canRemove(CatalogInfo info) {
        return null;
    }
}

