/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.ListChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.MinimumValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.admin.ServerAdminPage;

public class GlobalSettingsPage
extends ServerAdminPage {
    private static final long serialVersionUID = 4716657682337915996L;
    static final List<String> DEFAULT_LOG_PROFILES = Arrays.asList("DEFAULT_LOGGING.properties", "VERBOSE_LOGGING.properties", "PRODUCTION_LOGGING.properties", "GEOTOOLS_DEVELOPER_LOGGING.properties", "GEOSERVER_DEVELOPER_LOGGING.properties");
    public static final ArrayList<String> AVAILABLE_CHARSETS = new ArrayList<String>(Charset.availableCharsets().keySet());

    public GlobalSettingsPage() {
        final IModel globalInfoModel = this.getGlobalInfoModel();
        final IModel loggingInfoModel = this.getLoggingInfoModel();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)globalInfoModel));
        this.add(new Component[]{form});
        form.add(new Component[]{new CheckBox("verbose")});
        form.add(new Component[]{new CheckBox("verboseExceptions")});
        form.add(new Component[]{new CheckBox("globalServices")});
        form.add(new Component[]{new TextField("numDecimals").add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(0)))});
        form.add(new Component[]{new DropDownChoice("charset", AVAILABLE_CHARSETS)});
        form.add(new Component[]{new DropDownChoice("resourceErrorHandling", Arrays.asList(ResourceErrorHandling.values()))});
        form.add(new Component[]{new TextField("proxyBaseUrl").add((IValidator)new UrlValidator())});
        this.logLevelsAppend(form, loggingInfoModel);
        form.add(new Component[]{new CheckBox("stdOutLogging", (IModel)new PropertyModel((Object)loggingInfoModel, "stdOutLogging"))});
        form.add(new Component[]{new TextField("loggingLocation", (IModel)new PropertyModel((Object)loggingInfoModel, "location"))});
        TextField xmlPostRequestLogBufferSize = new TextField("xmlPostRequestLogBufferSize", (IModel)new PropertyModel((Object)globalInfoModel, "xmlPostRequestLogBufferSize"));
        xmlPostRequestLogBufferSize.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{xmlPostRequestLogBufferSize});
        form.add(new Component[]{new TextField("featureTypeCacheSize").add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(0)))});
        Button submit = new Button("submit", (IModel)new StringResourceModel("submit", (Component)this, null)){

            public void onSubmit() {
                GeoServer gs = GlobalSettingsPage.this.getGeoServer();
                gs.save((GeoServerInfo)globalInfoModel.getObject());
                gs.save((LoggingInfo)loggingInfoModel.getObject());
                GlobalSettingsPage.this.doReturn();
            }
        };
        form.add(new Component[]{submit});
        Button cancel = new Button("cancel"){

            public void onSubmit() {
                GlobalSettingsPage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
    }

    private void logLevelsAppend(Form form, IModel loggingInfoModel) {
        GeoServerResourceLoader loader = GeoServerApplication.get().getBeanOfType(GeoServerResourceLoader.class);
        List<String> logProfiles = null;
        try {
            File logsDirectory = loader.find("logs");
            if (logsDirectory.exists() && logsDirectory.isDirectory()) {
                String[] propFiles = logsDirectory.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith("logging.properties");
                    }
                });
                logProfiles = Arrays.asList(propFiles);
                Collections.sort(logProfiles, String.CASE_INSENSITIVE_ORDER);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not load the list of log configurations from the data directory", e);
        }
        if (logProfiles == null || logProfiles.size() == 0) {
            logProfiles = DEFAULT_LOG_PROFILES;
        }
        form.add(new Component[]{new ListChoice("log4jConfigFile", (IModel)new PropertyModel((Object)loggingInfoModel, "level"), logProfiles)});
    }
}

