/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.MinimumValidator;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.web.admin.ServerAdminPage;
import org.geoserver.web.wicket.ParamResourceModel;

public class CoverageAccessPage
extends ServerAdminPage {
    public CoverageAccessPage() {
        final IModel geoServerModel = this.getGeoServerModel();
        final IModel<CoverageAccessInfo> coverageModel = this.getCoverageAccessModel();
        Form form = new Form("form", (IModel)new CompoundPropertyModel(coverageModel));
        this.add(new Component[]{form});
        form.add((IFormValidator)new PoolSizeValidator());
        TextField corePoolSize = new TextField("corePoolSize");
        corePoolSize.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{corePoolSize});
        TextField maxPoolSize = new TextField("maxPoolSize");
        maxPoolSize.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{maxPoolSize});
        TextField keepAliveTime = new TextField("keepAliveTime");
        keepAliveTime.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{keepAliveTime});
        DropDownChoice queueType = new DropDownChoice("queueType", Arrays.asList(CoverageAccessInfo.QueueType.values()), (IChoiceRenderer)new QueueTypeRenderer());
        form.add(new Component[]{queueType});
        TextField imageIOCacheThreshold = new TextField("imageIOCacheThreshold");
        imageIOCacheThreshold.add((IValidator)new MinimumValidator((Comparable)Long.valueOf(0L)));
        form.add(new Component[]{imageIOCacheThreshold});
        Button submit = new Button("submit", (IModel)new StringResourceModel("submit", (Component)this, null)){

            public void onSubmit() {
                GeoServer gs = (GeoServer)geoServerModel.getObject();
                GeoServerInfo global = gs.getGlobal();
                global.setCoverageAccess((CoverageAccessInfo)coverageModel.getObject());
                gs.save(global);
                CoverageAccessPage.this.doReturn();
            }
        };
        form.add(new Component[]{submit});
        Button cancel = new Button("cancel"){

            public void onSubmit() {
                CoverageAccessPage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
    }

    private class QueueTypeRenderer
    implements IChoiceRenderer {
        private QueueTypeRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((CoverageAccessInfo.QueueType)object).name(), (Component)CoverageAccessPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((CoverageAccessInfo.QueueType)object).name();
        }
    }

    class PoolSizeValidator
    extends AbstractFormValidator {
        private static final long serialVersionUID = -3435198454570572665L;

        PoolSizeValidator() {
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return null;
        }

        public void validate(Form<?> form) {
            if (form.findSubmittingButton() != form.get("submit")) {
                return;
            }
            Component maxPoolComponent = form.get("maxPoolSize");
            Component corePoolComponent = form.get("corePoolSize");
            if (maxPoolComponent != null && maxPoolComponent instanceof TextField && corePoolComponent != null && corePoolComponent instanceof TextField) {
                TextField maxPoolField = (TextField)maxPoolComponent;
                TextField corePoolField = (TextField)corePoolComponent;
                String mp = maxPoolField.getValue();
                String cp = corePoolField.getValue();
                if (mp != null && cp != null && !mp.trim().isEmpty() && !cp.trim().isEmpty()) {
                    int corePool;
                    int maxPool;
                    try {
                        maxPool = Integer.valueOf(mp);
                    }
                    catch (NumberFormatException nfe) {
                        return;
                    }
                    try {
                        corePool = Integer.valueOf(cp);
                    }
                    catch (NumberFormatException nfe) {
                        return;
                    }
                    if (maxPool >= 1 && corePool >= 1 && maxPool < corePool) {
                        form.error((Serializable)((Object)new ParamResourceModel("poolSizeCheck", (Component)CoverageAccessPage.this.getPage(), new Object[0]).getString()));
                    }
                }
            }
        }
    }
}

