/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.HashMap;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.geoserver.web.WicketCallback;
import org.geotools.filter.function.EnvFunction;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class WicketEnvironmentVariableCallback
implements WicketCallback {
    @Override
    public void onBeginRequest() {
        HashMap<String, String> envVars = null;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && !(auth instanceof AnonymousAuthenticationToken)) {
            String name = auth.getName();
            if (envVars == null) {
                envVars = new HashMap<String, String>();
            }
            envVars.put("GSUSER", name);
        }
        if (envVars != null) {
            EnvFunction.setLocalValues(envVars);
        }
    }

    @Override
    public void onAfterTargetsDetached() {
    }

    @Override
    public void onEndRequest() {
        EnvFunction.clearLocalValues();
    }

    @Override
    public void onRequestTargetSet(IRequestTarget requestTarget) {
    }

    @Override
    public void onRuntimeException(Page page, RuntimeException e) {
    }
}

