/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.protocol.http.WebRequest;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.DefaultPageAuthorizer;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerLoginPage;
import org.geoserver.web.UnauthorizedPage;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;

public class GeoServerSecuredPage
extends GeoServerBasePage {
    public static final ComponentAuthorizer DEFAULT_AUTHORIZER = new DefaultPageAuthorizer();
    public static final String SAVED_REQUEST = "SPRING_SECURITY_SAVED_REQUEST_KEY";

    public GeoServerSecuredPage() {
        Authentication auth = this.getSession().getAuthentication();
        if (auth == null || !auth.isAuthenticated() || auth instanceof AnonymousAuthenticationToken) {
            HttpServletRequest httpRequest = ((WebRequest)this.getRequest()).getHttpServletRequest();
            DefaultSavedRequest savedRequest = new DefaultSavedRequest(httpRequest, (PortResolver)new PortResolverImpl());
            HttpSession session = httpRequest.getSession();
            session.setAttribute(SAVED_REQUEST, (Object)savedRequest);
            this.setResponsePage(GeoServerLoginPage.class);
        } else if (!this.getPageAuthorizer().isAccessAllowed(((Object)((Object)this)).getClass(), auth)) {
            this.setResponsePage(UnauthorizedPage.class);
        }
    }

    protected ComponentAuthorizer getPageAuthorizer() {
        return DEFAULT_AUTHORIZER;
    }

    protected boolean isAuthenticatedAsAdmin() {
        return ComponentAuthorizer.ADMIN.isAccessAllowed(GeoServerSecuredPage.class, SecurityContextHolder.getContext().getAuthentication());
    }
}

