/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.web.CapabilitiesHomePageLinkProvider;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerHomePageContentProvider;
import org.geoserver.web.data.layer.LayerPage;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.store.NewDataPage;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.workspace.WorkspaceNewPage;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class GeoServerHomePage
extends GeoServerBasePage {
    public GeoServerHomePage() {
        GeoServer gs = this.getGeoServer();
        ContactInfo contact = gs.getGlobal().getContact();
        this.add(new Component[]{new ExternalLink("contactURL", contact.getOnlineResource()).add(new Component[]{new Label("contactName", contact.getContactOrganization())})});
        String version = String.valueOf(new ResourceModel("version").getObject());
        String contactEmail = contact.getContactEmail();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", version);
        params.put("contactEmail", contactEmail);
        Label label = new Label("footerMessage", (IModel)new StringResourceModel("GeoServerHomePage.footer", (Component)this, (IModel)new Model(params)));
        label.setEscapeModelStrings(false);
        this.add(new Component[]{label});
        Authentication auth = this.getSession().getAuthentication();
        if (this.isAdmin(auth)) {
            Fragment f = new Fragment("catalogLinks", "catalogLinksFragment", (MarkupContainer)this);
            Catalog catalog = this.getCatalog();
            f.add(new Component[]{new BookmarkablePageLink("layersLink", LayerPage.class).add(new Component[]{new Label("nlayers", "" + catalog.getLayers().size())})});
            f.add(new Component[]{new BookmarkablePageLink("addLayerLink", NewLayerPage.class)});
            f.add(new Component[]{new BookmarkablePageLink("storesLink", StorePage.class).add(new Component[]{new Label("nstores", "" + catalog.getStores(StoreInfo.class).size())})});
            f.add(new Component[]{new BookmarkablePageLink("addStoreLink", NewDataPage.class)});
            f.add(new Component[]{new BookmarkablePageLink("workspacesLink", WorkspacePage.class).add(new Component[]{new Label("nworkspaces", "" + catalog.getWorkspaces().size())})});
            f.add(new Component[]{new BookmarkablePageLink("addWorkspaceLink", WorkspaceNewPage.class)});
            this.add(new Component[]{f});
        } else {
            Label placeHolder = new Label("catalogLinks");
            placeHolder.setVisible(false);
            this.add(new Component[]{placeHolder});
        }
        IModel<List<GeoServerHomePageContentProvider>> contentProviders = this.getContentProviders(GeoServerHomePageContentProvider.class);
        ListView<GeoServerHomePageContentProvider> contentView = new ListView<GeoServerHomePageContentProvider>("contributedContent", contentProviders){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<GeoServerHomePageContentProvider> item) {
                GeoServerHomePageContentProvider provider = (GeoServerHomePageContentProvider)item.getModelObject();
                Component extraContent = provider.getPageBodyComponent("contentList");
                if (null == extraContent) {
                    Label placeHolder = new Label("contentList");
                    placeHolder.setVisible(false);
                    extraContent = placeHolder;
                }
                item.add(new Component[]{extraContent});
            }
        };
        this.add(new Component[]{contentView});
        IModel<List<CapabilitiesHomePageLinkProvider>> capsProviders = this.getContentProviders(CapabilitiesHomePageLinkProvider.class);
        ListView<CapabilitiesHomePageLinkProvider> capsView = new ListView<CapabilitiesHomePageLinkProvider>("providedCaps", capsProviders){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<CapabilitiesHomePageLinkProvider> item) {
                CapabilitiesHomePageLinkProvider provider = (CapabilitiesHomePageLinkProvider)item.getModelObject();
                Component capsList = provider.getCapabilitiesComponent("capsList");
                item.add(new Component[]{capsList});
            }
        };
        this.add(new Component[]{capsView});
    }

    private <T> IModel<List<T>> getContentProviders(final Class<T> providerClass) {
        LoadableDetachableModel providersModel = new LoadableDetachableModel<List<T>>(){
            private static final long serialVersionUID = 1L;

            protected List<T> load() {
                GeoServerApplication app = GeoServerHomePage.this.getGeoServerApplication();
                List providers = app.getBeansOfType(providerClass);
                return providers;
            }
        };
        return providersModel;
    }

    private boolean isAdmin(Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            return false;
        }
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!"ROLE_ADMINISTRATOR".equals(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }
}

