/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.wicket.Application;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.IResponseFilter;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebRequestCycleProcessor;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.request.IRequestCodingStrategy;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.spring.SpringWebApplication;
import org.apache.wicket.util.convert.ConverterLocator;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.web.GeoServerErrorPage;
import org.geoserver.web.GeoServerExpiredPage;
import org.geoserver.web.GeoServerHTMLValidatorResponseFilter;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerRequestEncodingStrategy;
import org.geoserver.web.GeoServerResourceStreamLocator;
import org.geoserver.web.GeoServerStringResourceLoader;
import org.geoserver.web.GeoserverWicketEncrypterFactory;
import org.geoserver.web.WicketCallback;
import org.geoserver.web.spring.security.GeoServerSession;
import org.geoserver.web.util.DataDirectoryConverterLocator;
import org.geoserver.web.util.GeoToolsConverterAdapter;
import org.geoserver.web.util.converters.StringBBoxConverter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;

public class GeoServerApplication
extends SpringWebApplication {
    public static Logger LOGGER = Logging.getLogger((String)"org.geoserver.web");

    public Class<GeoServerHomePage> getHomePage() {
        return GeoServerHomePage.class;
    }

    public static GeoServerApplication get() {
        return (GeoServerApplication)Application.get();
    }

    public ApplicationContext getApplicationContext() {
        return this.internalGetApplicationContext();
    }

    public GeoServer getGeoServer() {
        return this.getBeanOfType(GeoServer.class);
    }

    public Catalog getCatalog() {
        return this.getGeoServer().getCatalog();
    }

    public GeoServerSecurityManager getSecurityManager() {
        return this.getBeanOfType(GeoServerSecurityManager.class);
    }

    public GeoServerResourceLoader getResourceLoader() {
        return this.getBeanOfType(GeoServerResourceLoader.class);
    }

    public <T> T getBeanOfType(Class<T> type) {
        return (T)GeoServerExtensions.bean(type, (ApplicationContext)this.getApplicationContext());
    }

    public Object getBean(String name) {
        return GeoServerExtensions.bean((String)name);
    }

    public <T> List<T> getBeansOfType(Class<T> type) {
        return GeoServerExtensions.extensions(type, (ApplicationContext)this.getApplicationContext());
    }

    public void clearWicketCaches() {
        this.getResourceSettings().getPropertiesFactory().clearCache();
        this.getResourceSettings().getLocalizer().clearCache();
    }

    protected void init() {
        this.getResourceSettings().setResourceStreamLocator((IResourceStreamLocator)new GeoServerResourceStreamLocator());
        List<IStringResourceLoader> alternateResourceLoaders = this.getBeansOfType(IStringResourceLoader.class);
        for (IStringResourceLoader loader : alternateResourceLoaders) {
            LOGGER.info("Registering alternate resource loader: " + loader);
            this.getResourceSettings().addStringResourceLoader(loader);
        }
        this.getResourceSettings().addStringResourceLoader(0, (IStringResourceLoader)new GeoServerStringResourceLoader());
        this.getResourceSettings().setDisableGZipCompression(true);
        if ("development".equalsIgnoreCase(this.getConfigurationType())) {
            this.getMarkupSettings().setStripWicketTags(true);
            GeoServerHTMLValidatorResponseFilter htmlvalidator = new GeoServerHTMLValidatorResponseFilter();
            htmlvalidator.setIgnoreAutocomplete(true);
            htmlvalidator.setIgnoreKnownWicketBugs(true);
            this.getRequestCycleSettings().addResponseFilter((IResponseFilter)htmlvalidator);
        }
        this.getDebugSettings().setAjaxDebugModeEnabled(false);
        this.getApplicationSettings().setPageExpiredErrorPage(GeoServerExpiredPage.class);
        this.getSecuritySettings().setCryptFactory(GeoserverWicketEncrypterFactory.get());
    }

    public String getConfigurationType() {
        String config = GeoServerExtensions.getProperty((String)"wicket.configuration", (ApplicationContext)this.getApplicationContext());
        if (config == null) {
            return "deployment";
        }
        if (!"deployment".equalsIgnoreCase(config) && !"development".equalsIgnoreCase(config)) {
            LOGGER.warning("Unknown Wicket configuration value '" + config + "', defaulting to DEPLOYMENT");
            return "deployment";
        }
        return config;
    }

    public Session newSession(Request request, Response response) {
        GeoServerSession s = new GeoServerSession(request);
        if (s.getLocale() == null) {
            s.setLocale(Locale.ENGLISH);
        }
        return s;
    }

    protected IRequestCycleProcessor newRequestCycleProcessor() {
        return new RequestCycleProcessor();
    }

    public final RequestCycle newRequestCycle(Request request, Response response) {
        return new RequestCycle(this, (WebRequest)request, (WebResponse)response);
    }

    protected IConverterLocator newConverterLocator() {
        ConverterLocator locator = new ConverterLocator();
        locator.set(ReferencedEnvelope.class, (IConverter)new GeoToolsConverterAdapter(new StringBBoxConverter(), ReferencedEnvelope.class));
        DataDirectoryConverterLocator dd = new DataDirectoryConverterLocator(this.getResourceLoader());
        locator.set(File.class, dd.getConverter(File.class));
        locator.set(URI.class, dd.getConverter(URI.class));
        locator.set(URL.class, dd.getConverter(URL.class));
        return locator;
    }

    private IConverterLocator buildConverterLocator() {
        ConverterLocator locator = new ConverterLocator();
        return locator;
    }

    static class RequestCycle
    extends WebRequestCycle {
        private List<WicketCallback> callbacks;

        public RequestCycle(GeoServerApplication app, WebRequest req, WebResponse resp) {
            super((WebApplication)app, req, (Response)resp);
            this.callbacks = app.getBeansOfType(WicketCallback.class);
        }

        protected void onBeginRequest() {
            for (WicketCallback callback : this.callbacks) {
                callback.onBeginRequest();
            }
        }

        protected void onAfterTargetsDetached() {
            for (WicketCallback callback : this.callbacks) {
                callback.onAfterTargetsDetached();
            }
        }

        protected void onEndRequest() {
            for (WicketCallback callback : this.callbacks) {
                callback.onEndRequest();
            }
        }

        public final Page onRuntimeException(Page cause, RuntimeException ex) {
            for (WicketCallback callback : this.callbacks) {
                callback.onRuntimeException(cause, ex);
            }
            if (ex instanceof PageExpiredException) {
                return super.onRuntimeException(cause, ex);
            }
            return new GeoServerErrorPage(cause, ex);
        }

        protected void onRequestTargetSet(IRequestTarget requestTarget) {
            for (WicketCallback callback : this.callbacks) {
                callback.onRequestTargetSet(requestTarget);
            }
            super.onRequestTargetSet(requestTarget);
        }
    }

    static class RequestCycleProcessor
    extends WebRequestCycleProcessor {
        RequestCycleProcessor() {
        }

        public IRequestTarget resolve(RequestCycle requestCycle, RequestParameters requestParameters) {
            IRequestTarget target = super.resolve((org.apache.wicket.RequestCycle)requestCycle, requestParameters);
            if (target != null) {
                return target;
            }
            return this.resolveHomePageTarget((org.apache.wicket.RequestCycle)requestCycle, requestParameters);
        }

        protected IRequestCodingStrategy newRequestCodingStrategy() {
            return new GeoServerRequestEncodingStrategy();
        }
    }
}

