/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.geotools.util.Version;

public class CapabilitiesHomePagePanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public CapabilitiesHomePagePanel(String id, List<CapsInfo> capsLinks) {
        super(id);
        final HashMap<String, ArrayList<CapsInfo>> byService = new HashMap<String, ArrayList<CapsInfo>>();
        for (CapsInfo c : capsLinks) {
            ArrayList<CapsInfo> serviceLinks = (ArrayList<CapsInfo>)byService.get(c.getService());
            if (serviceLinks == null) {
                serviceLinks = new ArrayList<CapsInfo>();
                byService.put(c.getService(), serviceLinks);
            }
            serviceLinks.add(c);
        }
        ArrayList services = new ArrayList(byService.keySet());
        Collections.sort(services);
        ListView<String> view = new ListView<String>("services", services){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                String serviceId = (String)item.getModelObject();
                item.add(new Component[]{new Label("service", serviceId.toUpperCase())});
                item.add(new Component[]{new ListView<CapsInfo>("versions", (List)byService.get(serviceId)){
                    private static final long serialVersionUID = 1L;

                    protected void populateItem(ListItem<CapsInfo> item) {
                        CapsInfo capsInfo = (CapsInfo)item.getModelObject();
                        Version version = capsInfo.getVersion();
                        String capsLink = capsInfo.getCapsLink();
                        ExternalLink link = new ExternalLink("link", capsLink);
                        item.add(new Component[]{link});
                        link.add(new Component[]{new Label("version", version.toString())});
                    }
                }});
            }
        };
        this.add(new Component[]{view});
    }

    public static class CapsInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String service;
        Version version;
        String capsLink;

        public CapsInfo(String service, Version version, String capsLink) {
            this.service = service;
            this.version = version;
            this.capsLink = capsLink;
        }

        public String getService() {
            return this.service;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getCapsLink() {
            return this.capsLink;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CapsInfo)) {
                return false;
            }
            CapsInfo ci = (CapsInfo)o;
            return this.service.equals(ci.service) && this.version.equals((Object)ci.version) && this.capsLink.equals(ci.capsLink);
        }
    }
}

