/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.form.upload;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadInfo;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadWebRequest;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.upload.FileUploadException;

class MultipartRequest
extends MultipartServletWebRequest {
    public MultipartRequest(HttpServletRequest req, Bytes maxSize) throws FileUploadException {
        super(req, maxSize);
        if (req == null) {
            throw new IllegalStateException("req cannot be null");
        }
    }

    protected boolean wantUploadProgressUpdates() {
        return true;
    }

    protected void onUploadStarted(int totalBytes) {
        UploadInfo info = new UploadInfo(totalBytes);
        HttpServletRequest request = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
        UploadWebRequest.setUploadInfo(request, info);
    }

    protected void onUploadUpdate(int bytesUploaded, int total) {
        HttpServletRequest request = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
        UploadInfo info = UploadWebRequest.getUploadInfo(request);
        if (info == null) {
            throw new IllegalStateException("could not find UploadInfo object in session which should have been set when uploaded started");
        }
        info.setBytesUploaded(bytesUploaded);
        UploadWebRequest.setUploadInfo(request, info);
    }

    protected void onUploadCompleted() {
        HttpServletRequest request = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
        UploadWebRequest.clearUploadInfo(request);
    }
}

