/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.exception;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.exception.IGeoServerException;

public class GeoServerExceptions {
    static Logger LOGGER = Logger.getLogger("org.geoserver.platform.exception");
    static Control control = new Control();

    public static String localize(IGeoServerException e) {
        return GeoServerExceptions.localize(e, Locale.getDefault());
    }

    public static String localize(IGeoServerException e, Locale locale) {
        Class<?> clazz = e.getClass();
        while (clazz != null) {
            String localized = GeoServerExceptions.doLocalize(e.getId(), e.getArgs(), clazz, locale);
            if (localized != null) {
                return localized;
            }
            if (IGeoServerException.class.isAssignableFrom(clazz.getSuperclass())) {
                clazz = clazz.getSuperclass();
                continue;
            }
            clazz = null;
        }
        return null;
    }

    static String doLocalize(String id, Object[] args, Class<? extends IGeoServerException> clazz, Locale locale) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("GeoServerException", locale, control);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (bundle == null) {
            return null;
        }
        String localized = null;
        try {
            localized = bundle.getString(clazz.getCanonicalName() + "." + id);
        }
        catch (MissingResourceException ex) {
            try {
                localized = bundle.getString(clazz.getSimpleName() + "." + id);
            }
            catch (MissingResourceException ex2) {
                // empty catch block
            }
        }
        if (localized == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Resource lookup failed for key" + id + ", class = " + clazz);
            }
            return null;
        }
        if (args != null && args.length > 0) {
            localized = MessageFormat.format(localized, args);
        }
        return localized;
    }

    static class PropResourceBundle
    extends ResourceBundle {
        Properties props;

        PropResourceBundle(Properties props) {
            this.props = props;
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.props.get(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.props.keys();
        }
    }

    static class Control
    extends ResourceBundle.Control {
        static final List<String> FORMATS = Arrays.asList("java.properties");

        Control() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return FORMATS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String lang = locale.getLanguage();
            String filename = baseName;
            if (lang != null && !"".equals(lang)) {
                filename = filename + "_" + lang;
            }
            filename = filename + ".properties";
            Enumeration<URL> e = loader.getResources(filename);
            Properties props = null;
            while (e.hasMoreElements()) {
                if (props == null) {
                    props = new Properties();
                }
                URL url = e.nextElement();
                InputStream in = url.openStream();
                try {
                    props.load(in);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Error loading properties from: ", url);
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (Exception ex2) {
                        LOGGER.log(Level.FINEST, ex2.getMessage(), ex2);
                    }
                }
            }
            return props != null ? new PropResourceBundle(props) : null;
        }
    }
}

