/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.List;
import org.geotools.util.Version;

public final class Service {
    final String id;
    final String namespace;
    final Object service;
    final Version version;
    final List<String> operations;

    public Service(String id, Object service, Version version, List<String> operations) {
        this(id, null, service, version, operations);
    }

    public Service(String id, String namespace, Object service, Version version, List<String> operations) {
        this.id = id;
        this.service = service;
        this.version = version;
        this.operations = operations;
        this.namespace = namespace;
        if (id == null) {
            throw new NullPointerException("id");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getService() {
        return this.service;
    }

    public Version getVersion() {
        return this.version;
    }

    public List<String> getOperations() {
        return this.operations;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals((Object)other.version)) {
            return false;
        }
        return ((Object)this.operations).equals(other.operations);
    }

    public int hashCode() {
        int result = 0;
        result = this.id.hashCode();
        if (this.version != null) {
            result = result * 17 + this.version.hashCode();
        }
        result = result * 17 + ((Object)this.operations).hashCode();
        return result;
    }

    public String toString() {
        return "Service( " + this.id + ", " + this.version + " )";
    }
}

