/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileWatcher<T> {
    File file;
    private long lastModified = Long.MIN_VALUE;
    private long lastCheck;
    private boolean stale;

    public FileWatcher(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read() throws IOException {
        T result = null;
        if (this.file.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.file);
                result = this.parseFileContents(is);
                this.lastModified = this.file.lastModified();
                this.lastCheck = System.currentTimeMillis();
                this.stale = false;
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        return result;
    }

    protected T parseFileContents(InputStream in) throws IOException {
        return null;
    }

    public boolean isModified() {
        long now = System.currentTimeMillis();
        if (now - this.lastCheck > 1000L) {
            this.lastCheck = now;
            this.stale = this.file.exists() && this.file.lastModified() != this.lastModified;
        }
        return this.stale;
    }

    public void setKnownLastModified(long lastModified) {
        this.lastModified = lastModified;
    }
}

