/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.rest.GWCRestlet;
import org.geowebcache.rest.RestletException;
import org.geowebcache.rest.seed.SeedFormRestlet;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;

public class SeedRestlet
extends GWCRestlet {
    private static Log log = LogFactory.getLog(SeedFormRestlet.class);
    private TileBreeder seeder;
    public JSONObject myrequest;
    private XMLConfiguration xmlConfig;

    public void handle(Request request, Response response) {
        block5: {
            Method met = request.getMethod();
            try {
                if (met.equals((Object)Method.GET)) {
                    this.doGet(request, response);
                    break block5;
                }
                if (met.equals((Object)Method.POST)) {
                    this.doPost(request, response);
                    break block5;
                }
                throw new RestletException("Method not allowed", Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
            catch (RestletException re) {
                response.setEntity(re.getRepresentation());
                response.setStatus(re.getStatus());
            }
            catch (IOException ioe) {
                response.setEntity("Encountered IO error " + ioe.getMessage(), MediaType.TEXT_PLAIN);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
        }
    }

    public void doGet(Request req, Response resp) throws RestletException {
        String layerName;
        JsonRepresentation rep = null;
        if (req.getAttributes().containsKey("layer")) {
            try {
                layerName = URLDecoder.decode((String)req.getAttributes().get("layer"), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        } else {
            layerName = null;
        }
        try {
            long[][] list;
            XStream xs = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
            JSONObject obj = null;
            if (null == layerName) {
                list = this.seeder.getStatusList();
            } else {
                try {
                    this.seeder.findTileLayer(layerName);
                }
                catch (GeoWebCacheException e) {
                    throw new RestletException(e.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
                }
                list = this.seeder.getStatusList(layerName);
            }
            obj = new JSONObject(xs.toXML((Object)list));
            rep = new JsonRepresentation(obj);
        }
        catch (JSONException jse) {
            jse.printStackTrace();
        }
        resp.setEntity(rep);
    }

    public void doPost(Request req, Response resp) throws RestletException, IOException {
        String formatExtension = (String)req.getAttributes().get("extension");
        SeedRequest sr = null;
        XStream xs = this.xmlConfig.getConfiguredXStream(new XStream((HierarchicalStreamDriver)new DomDriver()));
        if (formatExtension.equalsIgnoreCase("xml")) {
            sr = (SeedRequest)xs.fromXML(req.getEntity().getStream());
        } else if (formatExtension.equalsIgnoreCase("json")) {
            sr = (SeedRequest)xs.fromXML(this.convertJson(req.getEntity().getText()));
        } else {
            throw new RestletException("Format extension unknown or not specified: " + formatExtension, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        String layerName = null;
        try {
            layerName = URLDecoder.decode((String)req.getAttributes().get("layer"), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        try {
            this.seeder.seed(layerName, sr);
        }
        catch (IllegalArgumentException e) {
            throw new RestletException(e.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
        }
        catch (GeoWebCacheException e) {
            throw new RestletException(e.getMessage(), Status.SERVER_ERROR_INTERNAL);
        }
    }

    private String convertJson(String entityText) throws IOException {
        JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
        StringReader reader = new StringReader(entityText);
        HierarchicalStreamReader hsr = driver.createReader((Reader)reader);
        StringWriter writer = new StringWriter();
        new HierarchicalStreamCopier().copy(hsr, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
        writer.close();
        return writer.toString();
    }

    public void setXmlConfig(XMLConfiguration xmlConfig) {
        this.xmlConfig = xmlConfig;
    }

    public void setTileBreeder(TileBreeder seeder) {
        this.seeder = seeder;
    }
}

