/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.rest.GWCRestlet;
import org.geowebcache.rest.RestletException;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.TileRange;
import org.geowebcache.util.ServletUtils;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedFormRestlet
extends GWCRestlet {
    private TileBreeder seeder;

    public void handle(Request request, Response response) {
        block6: {
            Method met = request.getMethod();
            try {
                if (met.equals((Object)Method.GET)) {
                    this.doGet(request, response);
                    break block6;
                }
                if (met.equals((Object)Method.POST)) {
                    try {
                        this.doPost(request, response);
                        break block6;
                    }
                    catch (GeoWebCacheException e) {
                        throw new RestletException(e.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
                    }
                }
                throw new RestletException("Method not allowed", Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
            catch (RestletException re) {
                response.setEntity(re.getRepresentation());
                response.setStatus(re.getStatus());
            }
        }
    }

    public void doGet(Request request, Response response) throws RestletException {
        TileLayer tl;
        String layerName = null;
        try {
            layerName = URLDecoder.decode((String)request.getAttributes().get("layer"), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        try {
            tl = this.seeder.findTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new RestletException(e.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
        }
        this.handleDoGet(response, tl, false);
    }

    private void handleDoGet(Response response, TileLayer tl, boolean listAllTasks) {
        response.setEntity(this.makeFormPage(tl, listAllTasks), MediaType.TEXT_HTML);
    }

    public void doPost(Request req, Response resp) throws RestletException, GeoWebCacheException {
        TileLayer tl;
        String layerName = null;
        if (req.getAttributes().containsKey("layer")) {
            try {
                layerName = URLDecoder.decode((String)req.getAttributes().get("layer"), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
            try {
                tl = this.seeder.findTileLayer(layerName);
            }
            catch (GeoWebCacheException e) {
                throw new RestletException(e.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
            }
        }
        tl = null;
        Form form = req.getEntityAsForm();
        if (form == null) {
            throw new RestletException("Unable to parse form result.", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        if (form.getFirst("list") != null) {
            if (tl == null) {
                throw new RestletException("No layer specified", Status.CLIENT_ERROR_BAD_REQUEST);
            }
            boolean listAllTasks = "all".equals(form.getFirst("list").getValue());
            this.handleDoGet(resp, tl, listAllTasks);
        } else if (form.getFirst("kill_thread") != null) {
            this.handleKillThreadPost(form, tl, resp);
        } else if (form.getFirst("kill_all") != null) {
            this.handleKillAllThreadsPost(form, tl, resp);
        } else if (form.getFirst("minX") != null) {
            if (tl == null) {
                throw new RestletException("No layer specified", Status.CLIENT_ERROR_BAD_REQUEST);
            }
            this.handleDoSeedPost(form, tl, resp);
        } else {
            throw new RestletException("Unknown or malformed request. Please try again, somtimes the form is not properly received. This frequently happens on the first POST after a restart. The POST was to " + req.getResourceRef().getPath(), Status.CLIENT_ERROR_BAD_REQUEST);
        }
    }

    private String makeFormPage(TileLayer tl, boolean listAllTasks) {
        StringBuilder doc = new StringBuilder();
        this.makeHeader(doc);
        this.makeTaskList(doc, tl, listAllTasks);
        this.makeWarningsAndHints(doc, tl);
        this.makeFormHeader(doc, tl);
        this.makeThreadCountPullDown(doc);
        this.makeTypePullDown(doc);
        this.makeGridSetPulldown(doc, tl);
        this.makeFormatPullDown(doc, tl);
        this.makeZoomStartPullDown(doc, tl);
        this.makeZoomStopPullDown(doc, tl);
        this.makeModifiableParameters(doc, tl);
        this.makeBboxFields(doc);
        this.makeSubmit(doc);
        this.makeFormFooter(doc);
        this.makeFooter(doc);
        return doc.toString();
    }

    private void makeModifiableParameters(StringBuilder doc, TileLayer tl) {
        List parameterFilters = tl.getParameterFilters();
        if (parameterFilters == null || parameterFilters.size() == 0) {
            return;
        }
        doc.append("<tr><td>Modifiable Parameters:</td><td>\n");
        doc.append("<table>");
        for (ParameterFilter pf : parameterFilters) {
            Assert.notNull((Object)pf);
            String key = pf.getKey();
            String defaultValue = pf.getDefaultValue();
            List legalValues = pf.getLegalValues();
            doc.append("<tr><td>").append(key.toUpperCase()).append(": ").append("</td><td>");
            String parameterId = "parameter_" + key;
            if (pf instanceof StringParameterFilter) {
                Map<String, String> keysValues = this.makeParametersMap(defaultValue, legalValues);
                this.makePullDown(doc, parameterId, keysValues, defaultValue);
            } else if (pf instanceof RegexParameterFilter) {
                this.makeTextInput(doc, parameterId, 25);
            } else if (pf instanceof FloatParameterFilter) {
                FloatParameterFilter floatFilter = (FloatParameterFilter)pf;
                if (floatFilter.getValues().isEmpty()) {
                    this.makeTextInput(doc, parameterId, 25);
                } else {
                    Map<String, String> keysValues = this.makeParametersMap(defaultValue, legalValues);
                    this.makePullDown(doc, parameterId, keysValues, defaultValue);
                }
            } else if ("org.geowebcache.filter.parameters.NaiveWMSDimensionFilter".equals(pf.getClass().getName())) {
                this.makeTextInput(doc, parameterId, 25);
            } else {
                throw new IllegalStateException("Unknown parameter filter type for layer '" + tl.getName() + "': " + pf.getClass().getName());
            }
            doc.append("</td></tr>");
        }
        doc.append("</table>");
        doc.append("</td></tr>\n");
    }

    private Map<String, String> makeParametersMap(String defaultValue, List<String> legalValues) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String s : legalValues) {
            map.put(s, s);
        }
        map.put(defaultValue, defaultValue);
        return map;
    }

    private String makeResponsePage(TileLayer tl) {
        StringBuilder doc = new StringBuilder();
        this.makeHeader(doc);
        doc.append("<h3>Task submitted</h3>\n");
        doc.append("<p>Below you can find a list of currently executing tasks, take the numbers with a grain of salt");
        doc.append(" until the task has had a chance to run for a few minutes. ");
        this.makeTaskList(doc, tl, false);
        this.makeFooter(doc);
        return doc.toString();
    }

    private void makeTypePullDown(StringBuilder doc) {
        doc.append("<tr><td>Type of operation:</td><td>\n");
        TreeMap<String, String> keysValues = new TreeMap<String, String>();
        keysValues.put("Truncate - remove tiles", "truncate");
        keysValues.put("Seed - generate missing tiles", "seed");
        keysValues.put("Reseed - regenerate all tiles", "reseed");
        this.makePullDown(doc, "type", keysValues, "Seed - generate missing tiles");
        doc.append("</td></tr>\n");
    }

    private void makeThreadCountPullDown(StringBuilder doc) {
        doc.append("<tr><td>Number of tasks to use:</td><td>\n");
        TreeMap<String, String> keysValues = new TreeMap<String, String>();
        for (int i = 1; i < 17; ++i) {
            if (i < 10) {
                keysValues.put("0" + Integer.toString(i), "0" + Integer.toString(i));
                continue;
            }
            keysValues.put(Integer.toString(i), Integer.toString(i));
        }
        this.makePullDown(doc, "threadCount", keysValues, Integer.toString(2));
        doc.append("</td></tr>\n");
    }

    private void makeBboxFields(StringBuilder doc) {
        doc.append("<tr><td valign=\"top\">Bounding box:</td><td>\n");
        this.makeTextInput(doc, "minX", 6);
        this.makeTextInput(doc, "minY", 6);
        this.makeTextInput(doc, "maxX", 6);
        this.makeTextInput(doc, "maxY", 6);
        doc.append("</br>These are optional, approximate values are fine.");
        doc.append("</td></tr>\n");
    }

    private void makeBboxHints(StringBuilder doc, TileLayer tl) {
        for (String gridSetId : tl.getGridSubsets()) {
            GridSubset subset = tl.getGridSubset(gridSetId);
            doc.append("<li>" + gridSetId + ":   " + subset.getOriginalExtent().toString() + "</li>\n");
        }
    }

    private void makeTextInput(StringBuilder doc, String id, int size) {
        doc.append("<input name=\"" + id + "\" type=\"text\" size=\"" + size + "\" />\n");
    }

    private void makeSubmit(StringBuilder doc) {
        doc.append("<tr><td></td><td><input type=\"submit\" value=\"Submit\"></td></tr>\n");
    }

    private void makeZoomStopPullDown(StringBuilder doc, TileLayer tl) {
        doc.append("<tr><td>Zoom stop:</td><td>\n");
        this.makeZoomPullDown(doc, false, tl);
        doc.append("</td></tr>\n");
    }

    private void makeZoomStartPullDown(StringBuilder doc, TileLayer tl) {
        doc.append("<tr><td>Zoom start:</td><td>\n");
        this.makeZoomPullDown(doc, true, tl);
        doc.append("</td></tr>\n");
    }

    private void makeZoomPullDown(StringBuilder doc, boolean isStart, TileLayer tl) {
        TreeMap<String, String> keysValues = new TreeMap<String, String>();
        int minStart = Integer.MAX_VALUE;
        int maxStop = Integer.MIN_VALUE;
        for (String gridSetId : tl.getGridSubsets()) {
            GridSubset subset = tl.getGridSubset(gridSetId);
            int start = subset.getZoomStart();
            int stop = subset.getZoomStop();
            if (start < minStart) {
                minStart = start;
            }
            if (stop <= maxStop) continue;
            maxStop = stop;
        }
        for (int i = minStart; i <= maxStop; ++i) {
            if (i < 10) {
                keysValues.put("0" + Integer.toString(i), "0" + Integer.toString(i));
                continue;
            }
            keysValues.put(Integer.toString(i), Integer.toString(i));
        }
        if (isStart) {
            if (minStart < 10) {
                this.makePullDown(doc, "zoomStart", keysValues, "0" + Integer.toString(minStart));
            } else {
                this.makePullDown(doc, "zoomStart", keysValues, Integer.toString(minStart));
            }
        } else {
            int midStop = (minStart + maxStop) / 2;
            if (midStop < 10) {
                this.makePullDown(doc, "zoomStop", keysValues, "0" + Integer.toString(midStop));
            } else {
                this.makePullDown(doc, "zoomStop", keysValues, Integer.toString(midStop));
            }
        }
    }

    private void makeFormatPullDown(StringBuilder doc, TileLayer tl) {
        doc.append("<tr><td>Format:</td><td>\n");
        TreeMap<String, String> keysValues = new TreeMap<String, String>();
        for (MimeType mime : tl.getMimeTypes()) {
            keysValues.put(mime.getFormat(), mime.getFormat());
        }
        this.makePullDown(doc, "format", keysValues, ImageMime.png.getFormat());
        doc.append("</td></tr>\n");
    }

    private void makeGridSetPulldown(StringBuilder doc, TileLayer tl) {
        doc.append("<tr><td>Grid Set:</td><td>\n");
        TreeMap<String, String> keysValues = new TreeMap<String, String>();
        String firstGridSetId = null;
        for (String gridSetId : tl.getGridSubsets()) {
            if (firstGridSetId == null) {
                firstGridSetId = gridSetId;
            }
            keysValues.put(gridSetId, gridSetId);
        }
        this.makePullDown(doc, "gridSetId", keysValues, firstGridSetId);
        doc.append("</td></tr>\n");
    }

    private void makePullDown(StringBuilder doc, String id, Map<String, String> keysValues, String defaultKey) {
        doc.append("<select name=\"" + id + "\">\n");
        for (Map.Entry<String, String> entry : keysValues.entrySet()) {
            if (entry.getKey().equals(defaultKey)) {
                doc.append("<option value=\"" + entry.getValue() + "\" selected=\"selected\">" + entry.getKey() + "</option>\n");
                continue;
            }
            doc.append("<option value=\"" + entry.getValue() + "\">" + entry.getKey() + "</option>\n");
        }
        doc.append("</select>\n");
    }

    private void makeFormHeader(StringBuilder doc, TileLayer tl) {
        doc.append("<h4>Create a new task:</h4>\n");
        doc.append("<form id=\"seed\" action=\"./" + tl.getName() + "\" method=\"post\">\n");
        doc.append("<table border=\"0\" cellspacing=\"10\">\n");
    }

    private void makeFormFooter(StringBuilder doc) {
        doc.append("</table>\n");
        doc.append("</form>\n");
    }

    private void makeHeader(StringBuilder doc) {
        doc.append("<html>\n" + ServletUtils.gwcHtmlHeader((String)"GWC Seed Form") + "<body>\n" + ServletUtils.gwcHtmlLogoLink((String)"../../"));
    }

    private void makeWarningsAndHints(StringBuilder doc, TileLayer tl) {
        doc.append("<h4>Please note:</h4><ul>\n<li>This minimalistic interface does not check for correctness.</li>\n<li>Seeding past zoomlevel 20 is usually not recommended.</li>\n<li>Truncating KML will also truncate all KMZ archives.</li>\n<li>Please check the logs of the container to look for error messages and progress indicators.</li>\n</ul>\n");
        doc.append("Here are the max bounds, if you do not specify bounds these will be used.\n");
        doc.append("<ul>\n");
        this.makeBboxHints(doc, tl);
        doc.append("</ul>\n");
    }

    private void makeTaskList(StringBuilder doc, TileLayer tl, boolean listAll) {
        doc.append(this.makeKillallThreadsForm(tl, listAll));
        doc.append("<h4>List of currently executing tasks:</h4>\n");
        Iterator iter = this.seeder.getRunningAndPendingTasks();
        boolean tasks = false;
        if (!iter.hasNext()) {
            doc.append("<ul><li><i>none</i></li></ul>\n");
        } else {
            doc.append("<table border=\"0\">");
            doc.append("<tr style=\"font-weight: bold;\"><td style=\"padding-right:20px;\">Id</td><td style=\"padding-right:20px;\">Layer</td><td style=\"padding-right:20px;\">Status</td><td style=\"padding-right:20px;\">Type</td><td>Estimated # of tiles</td><td style=\"padding-right:20px;\">Tiles completed</td><td style=\"padding-right:20px;\">Time elapsed</td><td>Time remaining</td><td>Tasks</td><td>&nbsp;</td>");
            doc.append("</tr>");
            tasks = true;
        }
        int row = 0;
        String layerName = tl.getName();
        while (iter.hasNext()) {
            GWCTask task = (GWCTask)iter.next();
            if (!listAll && !layerName.equals(task.getLayerName())) continue;
            long spent = task.getTimeSpent();
            long remining = task.getTimeRemaining();
            long tilesDone = task.getTilesDone();
            long tilesTotal = task.getTilesTotal();
            NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
            nf.setGroupingUsed(true);
            String tilesTotalStr = tilesTotal < 0L ? "Too many to count" : nf.format(tilesTotal);
            String tilesDoneStr = nf.format(task.getTilesDone());
            GWCTask.STATE state = task.getState();
            String status = GWCTask.STATE.UNSET.equals((Object)state) || GWCTask.STATE.READY.equals((Object)state) ? "PENDING" : state.toString();
            String timeSpent = this.toTimeString(spent, tilesDone, tilesTotal);
            String timeRemaining = this.toTimeString(remining, tilesDone, tilesTotal);
            String bgColor = ++row % 2 == 0 ? "#FFFFFF" : "#DDDDDD";
            doc.append("<tr style=\"background-color:" + bgColor + ";\">");
            doc.append("<td style=\"text-align:right\">").append(task.getTaskId()).append("</td>");
            doc.append("<td>");
            if (!layerName.equals(task.getLayerName())) {
                doc.append("<a href=\"./").append(task.getLayerName()).append("\">");
            }
            doc.append(task.getLayerName());
            if (!layerName.equals(task.getLayerName())) {
                doc.append("</a>");
            }
            doc.append("</td>");
            doc.append("<td>").append(status).append("</td>");
            doc.append("<td>").append(task.getType()).append("</td>");
            doc.append("<td>").append(tilesTotalStr).append("</td>");
            doc.append("<td>").append(tilesDoneStr).append("</td>");
            doc.append("<td>").append(timeSpent).append("</td>");
            doc.append("<td>").append(timeRemaining).append("</td>");
            doc.append("<td>(Task ").append(task.getThreadOffset() + 1).append(" of ").append(task.getThreadCount()).append(") </td>");
            doc.append("<td>").append(this.makeThreadKillForm(task.getTaskId(), tl)).append("</td>");
            doc.append("<tr>");
        }
        if (tasks) {
            doc.append("</table>");
        }
        doc.append("<p><a href=\"./" + layerName + "\">Refresh list</a></p>\n");
    }

    private String toTimeString(long timeSeconds, long tilesDone, long tilesTotal) {
        String timeString;
        if (tilesDone < 50L) {
            timeString = " Estimating...";
        } else {
            int MINUTE_SECONDS = 60;
            int HOUR_SECONDS = 3600;
            int DAY_SECONDS = 86400;
            if (timeSeconds == -2L && tilesDone < tilesTotal) {
                timeString = " A decade or three.";
            } else if (timeSeconds > 86400L) {
                timeString = timeSeconds / 86400L + " day(s) ";
                timeString = timeString + timeSeconds % 86400L / 3600L + "h)";
            } else if (timeSeconds > 3600L) {
                long hours = timeSeconds / 3600L;
                long minutes = timeSeconds % 3600L / 60L;
                timeString = hours + " hour" + (hours > 1L ? "s " : " ");
                timeString = timeString + (minutes == 0L ? "" : minutes + " m");
            } else if (timeSeconds > 60L) {
                long minutes = timeSeconds / 60L;
                long seconds = timeSeconds % 60L;
                timeString = minutes + " minute" + (minutes > 1L ? "s " : " ");
                timeString = timeString + (seconds == 0L ? "" : seconds + " s");
            } else {
                timeString = timeSeconds + " second" + (timeSeconds == 1L ? "" : "s");
            }
        }
        return timeString;
    }

    private String makeThreadKillForm(Long key, TileLayer tl) {
        String ret = "<form form id=\"kill\" action=\"./" + tl.getName() + "\" method=\"post\">" + "<input type=\"hidden\" name=\"kill_thread\"  value=\"1\" />" + "<input type=\"hidden\" name=\"thread_id\"  value=\"" + key + "\" />" + "<span><input style=\"padding: 0; margin-bottom: -12px; border: 1;\"type=\"submit\" value=\"Kill Task\"></span>" + "</form>";
        return ret;
    }

    private String makeKillallThreadsForm(TileLayer tl, boolean listAll) {
        StringBuilder doc = new StringBuilder();
        String layerName = tl.getName();
        int otherLayersTaskCount = 0;
        if (!listAll) {
            Iterator tasks = this.seeder.getRunningAndPendingTasks();
            while (tasks.hasNext()) {
                if (layerName.equals(((GWCTask)tasks.next()).getLayerName())) continue;
                ++otherLayersTaskCount;
            }
        }
        doc.append("<table><tr><td>");
        doc.append("<form form id=\"list\" action=\"./").append(layerName).append("\" method=\"post\">\n");
        doc.append("List ");
        doc.append("<select name=\"list\" onchange=\"this.form.submit();\">\n");
        doc.append("<option value=\"layer\"").append(listAll ? "" : " selected").append(">this Layer tasks</option>\n");
        doc.append("<option value=\"all\"").append(listAll ? " selected" : "").append(">all Layers tasks</option>\n");
        doc.append("</select>\n");
        if (!listAll) {
            doc.append(" (there are ");
            if (otherLayersTaskCount > 0) {
                doc.append(otherLayersTaskCount);
            } else {
                doc.append("no");
            }
            doc.append(" tasks for other Layers)");
        }
        doc.append("</form>\n");
        doc.append("</td></tr><tr><td>");
        doc.append("<form form id=\"kill\" action=\"./").append(layerName).append("\" method=\"post\">\n");
        doc.append("<span>Kill \n");
        doc.append("<select name=\"kill_all\">\n");
        doc.append("<option value=\"all\">all</option>\n");
        doc.append("<option value=\"running\">running</option>\n");
        doc.append("<option value=\"pending\">pending</option>\n");
        doc.append("</select>\n");
        doc.append(" Tasks for Layer '").append(layerName).append("'.");
        doc.append("<input type=\"submit\" value=\" Submit\">");
        doc.append("</span>\n");
        doc.append("</form>\n");
        doc.append("</td></tr></table>");
        return doc.toString();
    }

    private void makeFooter(StringBuilder doc) {
        doc.append("</body></html>\n");
    }

    private void handleKillAllThreadsPost(Form form, TileLayer tl, Response resp) throws RestletException {
        Iterator tasks;
        boolean allLayers = tl == null;
        String killCode = form.getFirst("kill_all").getValue();
        if ("1".equals(killCode) || "running".equalsIgnoreCase(killCode)) {
            killCode = "running";
            tasks = this.seeder.getRunningTasks();
        } else if ("pending".equalsIgnoreCase(killCode)) {
            tasks = this.seeder.getPendingTasks();
        } else if ("all".equalsIgnoreCase(killCode)) {
            tasks = this.seeder.getRunningAndPendingTasks();
        } else {
            throw new RestletException("Unknown kill_all code: '" + killCode + "'. One of all|running|pending is expected.", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        LinkedList<GWCTask> terminatedTasks = new LinkedList<GWCTask>();
        LinkedList<GWCTask> nonTerminatedTasks = new LinkedList<GWCTask>();
        while (tasks.hasNext()) {
            GWCTask task = (GWCTask)tasks.next();
            String layerName = task.getLayerName();
            if (!allLayers && !tl.getName().equals(layerName)) continue;
            long taskId = task.getTaskId();
            boolean terminated = this.seeder.terminateGWCTask(taskId);
            if (terminated) {
                terminatedTasks.add(task);
                continue;
            }
            nonTerminatedTasks.add(task);
        }
        StringBuilder doc = new StringBuilder();
        this.makeHeader(doc);
        doc.append("<p>Requested to terminate ").append(killCode).append(" tasks.");
        doc.append("Terminated tasks: <ul>");
        for (GWCTask t : terminatedTasks) {
            doc.append("<li>").append(t).append("</li>");
        }
        doc.append("</ul>Tasks already finished: <ul>");
        for (GWCTask t : nonTerminatedTasks) {
            doc.append("<li>").append(t).append("</li>");
        }
        if (tl != null) {
            doc.append("</ul><p><a href=\"./" + tl.getName() + "\">Go back</a></p>\n");
        }
        resp.setEntity(doc.toString(), MediaType.TEXT_HTML);
    }

    private void handleKillThreadPost(Form form, TileLayer tl, Response resp) {
        String id = form.getFirstValue("thread_id");
        StringBuilder doc = new StringBuilder();
        this.makeHeader(doc);
        if (this.seeder.terminateGWCTask(Long.parseLong(id))) {
            doc.append("<ul><li>Requested to terminate task " + id + ".</li></ul>");
        } else {
            doc.append("<ul><li>Sorry, either task " + id + " has not started yet, or it is a truncate task that cannot be interrutped.</li></ul>");
        }
        if (tl != null) {
            doc.append("<p><a href=\"./" + tl.getName() + "\">Go back</a></p>\n");
        }
        resp.setEntity(doc.toString(), MediaType.TEXT_HTML);
    }

    private void handleDoSeedPost(Form form, TileLayer tl, Response resp) throws RestletException, GeoWebCacheException {
        GWCTask[] tasks;
        BoundingBox bounds = null;
        if (form.getFirst("minX").getValue() != null) {
            bounds = new BoundingBox(SeedFormRestlet.parseDouble(form, "minX"), SeedFormRestlet.parseDouble(form, "minY"), SeedFormRestlet.parseDouble(form, "maxX"), SeedFormRestlet.parseDouble(form, "maxY"));
        }
        String gridSetId = form.getFirst("gridSetId").getValue();
        int threadCount = Integer.parseInt(form.getFirst("threadCount").getValue());
        int zoomStart = Integer.parseInt(form.getFirst("zoomStart").getValue());
        int zoomStop = Integer.parseInt(form.getFirst("zoomStop").getValue());
        String format = form.getFirst("format").getValue();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Set paramNames = form.getNames();
        String prefix = "parameter_";
        for (String name : paramNames) {
            if (!name.startsWith(prefix)) continue;
            String paramName = name.substring(prefix.length());
            String value = form.getFirstValue(name);
            parameters.put(paramName, value);
        }
        Map fullParameters = tl.getModifiableParameters(parameters, "UTF-8");
        GWCTask.TYPE type = GWCTask.TYPE.valueOf((String)form.getFirst("type").getValue().toUpperCase());
        String layerName = tl.getName();
        SeedRequest sr = new SeedRequest(layerName, bounds, gridSetId, threadCount, zoomStart, zoomStop, format, type, fullParameters);
        TileRange tr = TileBreeder.createTileRange((SeedRequest)sr, (TileLayer)tl);
        try {
            tasks = this.seeder.createTasks(tr, tl, sr.getType(), sr.getThreadCount().intValue(), sr.getFilterUpdate());
        }
        catch (GeoWebCacheException e) {
            throw new RestletException(e.getMessage(), Status.SERVER_ERROR_INTERNAL);
        }
        this.seeder.dispatchTasks(tasks);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        resp.setEntity(this.makeResponsePage(tl), MediaType.TEXT_HTML);
    }

    private static double parseDouble(Form form, String key) throws RestletException {
        String value = form.getFirst(key).getValue();
        if (value == null || value.length() == 0) {
            throw new RestletException("Missing value for " + key, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw new RestletException("Value for " + key + " is not a double", Status.CLIENT_ERROR_BAD_REQUEST);
        }
    }

    public void setTileBreeder(TileBreeder seeder) {
        this.seeder = seeder;
    }
}

