/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.layers;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.rest.GWCRestlet;
import org.geowebcache.rest.RestletException;
import org.geowebcache.rest.XstreamRepresentation;
import org.geowebcache.service.HttpErrorCodeException;
import org.geowebcache.util.ServletUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;

public class TileLayerRestlet
extends GWCRestlet {
    private XMLConfiguration xmlConfig;
    private TileLayerDispatcher layerDispatcher;

    public void handle(Request request, Response response) {
        block8: {
            Method met = request.getMethod();
            try {
                if (met.equals((Object)Method.GET)) {
                    this.doGet(request, response);
                    break block8;
                }
                if (met.equals((Object)Method.POST)) {
                    this.doPost(request, response);
                    break block8;
                }
                if (met.equals((Object)Method.PUT)) {
                    this.doPut(request, response);
                    break block8;
                }
                if (met.equals((Object)Method.DELETE)) {
                    this.doDelete(request, response);
                    break block8;
                }
                throw new RestletException("Method not allowed", Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
            catch (RestletException re) {
                response.setEntity(re.getRepresentation());
                response.setStatus(re.getStatus());
            }
            catch (HttpErrorCodeException httpException) {
                int errorCode = httpException.getErrorCode();
                Status status = Status.valueOf((int)errorCode);
                response.setStatus(status);
                response.setEntity(httpException.getMessage(), MediaType.TEXT_PLAIN);
            }
            catch (Exception e) {
                response.setEntity(e.getMessage() + " " + e.toString(), MediaType.TEXT_PLAIN);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
                e.printStackTrace();
            }
        }
    }

    protected void doGet(Request req, Response resp) throws RestletException {
        Representation representation;
        String layerName = (String)req.getAttributes().get("layer");
        String formatExtension = (String)req.getAttributes().get("extension");
        if (layerName == null) {
            String restRoot = req.getResourceRef().getParentRef().toString();
            if (restRoot.endsWith("/")) {
                restRoot = restRoot.substring(0, restRoot.length() - 1);
            }
            representation = this.listLayers(formatExtension, restRoot);
        } else {
            try {
                layerName = URLDecoder.decode(layerName, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            representation = this.doGetInternal(layerName, formatExtension);
        }
        resp.setEntity(representation);
    }

    Representation listLayers(String extension, final String restRoot) {
        if (null == extension) {
            extension = "xml";
        }
        ArrayList layerNames = new ArrayList(this.layerDispatcher.getLayerNames());
        Collections.sort(layerNames);
        if (!extension.equalsIgnoreCase("xml")) {
            if (extension.equalsIgnoreCase("html")) {
                throw new RestletException("Unknown or missing format extension : " + extension, Status.CLIENT_ERROR_BAD_REQUEST);
            }
            throw new RestletException("Unknown or missing format extension : " + extension, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        XstreamRepresentation representation = new XstreamRepresentation(layerNames);
        representation.setCharacterSet(CharacterSet.UTF_8);
        XStream xStream = representation.getXStream();
        xStream.alias("layers", List.class);
        this.xmlConfig.getConfiguredXStream(xStream);
        xStream.registerConverter(new Converter(){

            public boolean canConvert(Class type) {
                return List.class.isAssignableFrom(type);
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                List layers = (List)source;
                for (String name : layers) {
                    writer.startNode("layer");
                    writer.startNode("name");
                    writer.setValue(name);
                    writer.endNode();
                    writer.startNode("atom:link");
                    writer.addAttribute("xmlns:atom", "http://www.w3.org/2005/Atom");
                    writer.addAttribute("rel", "alternate");
                    String href = restRoot + "/layers/" + ServletUtils.URLEncode((String)name) + ".xml";
                    writer.addAttribute("href", href);
                    writer.addAttribute("type", MediaType.TEXT_XML.toString());
                    writer.endNode();
                    writer.endNode();
                }
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                throw new UnsupportedOperationException();
            }
        });
        return representation;
    }

    protected Representation doGetInternal(String layerName, String formatExtension) throws RestletException {
        TileLayer tl = TileLayerRestlet.findTileLayer(layerName, this.layerDispatcher);
        if (formatExtension.equalsIgnoreCase("xml")) {
            return this.getXMLRepresentation(tl);
        }
        if (formatExtension.equalsIgnoreCase("json")) {
            return this.getJsonRepresentation(tl);
        }
        throw new RestletException("Unknown or missing format extension : " + formatExtension, Status.CLIENT_ERROR_BAD_REQUEST);
    }

    private void doPost(Request req, Response resp) throws RestletException, IOException, GeoWebCacheException {
        TileLayer tl = this.deserializeAndCheckLayer(req, resp, false);
        try {
            Configuration configuration = this.layerDispatcher.modify(tl);
            configuration.save();
        }
        catch (IllegalArgumentException e) {
            throw new RestletException("Layer " + tl.getName() + " is not known by the configuration." + "Maybe it was loaded from another source, or you're trying to add a new " + "layer and need to do an HTTP PUT ?", Status.CLIENT_ERROR_BAD_REQUEST);
        }
    }

    private void doPut(Request req, Response resp) throws RestletException, IOException, GeoWebCacheException {
        TileLayer tl = this.deserializeAndCheckLayer(req, resp, true);
        TileLayer testtl = null;
        try {
            testtl = TileLayerRestlet.findTileLayer(tl.getName(), this.layerDispatcher);
        }
        catch (RestletException re) {
            // empty catch block
        }
        if (testtl != null) {
            throw new RestletException("Layer with name " + tl.getName() + " already exists, " + "use POST if you want to replace it.", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        Configuration config = this.layerDispatcher.addLayer(tl);
        config.save();
    }

    private void doDelete(Request req, Response resp) throws RestletException, GeoWebCacheException {
        String layerName = (String)req.getAttributes().get("layer");
        TileLayerRestlet.findTileLayer(layerName, this.layerDispatcher);
        try {
            Configuration configuration = this.layerDispatcher.removeLayer(layerName);
            if (configuration == null) {
                throw new RestletException("Configuration to remove layer not found", Status.SERVER_ERROR_INTERNAL);
            }
            configuration.save();
        }
        catch (IOException e) {
            throw new RestletException(e.getMessage(), Status.SERVER_ERROR_INTERNAL, (Exception)e);
        }
    }

    protected TileLayer deserializeAndCheckLayer(Request req, Response resp, boolean isPut) throws RestletException, IOException {
        String layerName = ServletUtils.URLDecode((String)((String)req.getAttributes().get("layer")), (String)"UTF-8");
        String formatExtension = (String)req.getAttributes().get("extension");
        InputStream is = req.getEntity().getStream();
        if (!isPut) {
            TileLayerRestlet.findTileLayer(layerName, this.layerDispatcher);
        }
        return this.deserializeAndCheckLayerInternal(layerName, formatExtension, is);
    }

    protected TileLayer deserializeAndCheckLayerInternal(String layerName, String formatExtension, InputStream is) throws RestletException, IOException {
        TileLayer newLayer;
        block7: {
            XStream xs = this.xmlConfig.getConfiguredXStream(new XStream((HierarchicalStreamDriver)new DomDriver()));
            try {
                if (formatExtension.equalsIgnoreCase("xml")) {
                    newLayer = (TileLayer)xs.fromXML(is);
                    break block7;
                }
                if (formatExtension.equalsIgnoreCase("json")) {
                    JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
                    HierarchicalStreamReader hsr = driver.createReader(is);
                    StringWriter writer = new StringWriter();
                    new HierarchicalStreamCopier().copy(hsr, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
                    writer.close();
                    newLayer = (TileLayer)xs.fromXML(writer.toString());
                    break block7;
                }
                throw new RestletException("Unknown or missing format extension: " + formatExtension, Status.CLIENT_ERROR_BAD_REQUEST);
            }
            catch (ConversionException xstreamExceptionWrapper) {
                Throwable cause = xstreamExceptionWrapper.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RestletException(cause.getMessage(), Status.SERVER_ERROR_INTERNAL, (Exception)cause);
            }
        }
        if (!newLayer.getName().equals(layerName)) {
            throw new RestletException("There is a mismatch between the name of the  layer in the submission and the URL you specified.", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        return newLayer;
    }

    public Representation getXMLRepresentation(TileLayer layer) {
        XStream xs = this.xmlConfig.getConfiguredXStream(new XStream());
        String xmlText = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xs.toXML((Object)layer);
        return new StringRepresentation((CharSequence)xmlText, MediaType.TEXT_XML);
    }

    public JsonRepresentation getJsonRepresentation(TileLayer layer) {
        JsonRepresentation rep = null;
        try {
            XStream xs = this.xmlConfig.getConfiguredXStream(new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver()));
            JSONObject obj = new JSONObject(xs.toXML((Object)layer));
            rep = new JsonRepresentation(obj);
        }
        catch (JSONException jse) {
            jse.printStackTrace();
        }
        return rep;
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.layerDispatcher = tileLayerDispatcher;
    }

    public void setXMLConfiguration(XMLConfiguration xmlConfig) {
        this.xmlConfig = xmlConfig;
    }
}

