/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v2_0;

import java.io.Reader;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.WFSURIHandler;
import org.geoserver.wfs.xml.WFSXmlUtils;
import org.geotools.util.Version;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;

public class WfsXmlReader
extends XmlRequestReader {
    GeoServer gs;

    public WfsXmlReader(String element, GeoServer gs) {
        super(new QName("http://www.opengis.net/wfs/2.0", element), new Version("2.0.0"), "wfs");
        this.gs = gs;
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        WFSConfiguration config = new WFSConfiguration();
        WFSXmlUtils.initWfsConfiguration((Configuration)config, this.gs, new FeatureTypeSchemaBuilder.GML32(this.gs));
        Parser parser = new Parser((Configuration)config);
        parser.getURIHandlers().add(0, new WFSURIHandler(this.gs));
        WFSInfo wfs = this.wfs();
        WFSXmlUtils.initRequestParser(parser, wfs, this.gs, kvp);
        Object parsed = null;
        try {
            parsed = WFSXmlUtils.parseRequest(parser, reader, wfs);
        }
        catch (Exception e2) {
            WFSException e2;
            if (!(e2 instanceof ServiceException) || ((ServiceException)e2).getCode() == null) {
                e2 = new WFSException("Request parsing failed", (Throwable)e2, "OperationParsingFailed");
            }
            throw e2;
        }
        WFSXmlUtils.checkValidationErrors(parser, this);
        return parsed;
    }

    WFSInfo wfs() {
        return (WFSInfo)this.gs.getService(WFSInfo.class);
    }
}

