/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSDescribeFeatureTypeOutputFormat;
import org.geoserver.wfs.request.DescribeFeatureTypeRequest;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.w3c.dom.Element;

public class XmlSchemaEncoder
extends WFSDescribeFeatureTypeOutputFormat {
    Catalog catalog;
    GeoServerResourceLoader resourceLoader;
    FeatureTypeSchemaBuilder schemaBuilder;

    public XmlSchemaEncoder(String mimeType, GeoServer gs, FeatureTypeSchemaBuilder schemaBuilder) {
        super(gs, mimeType);
        this.catalog = gs.getCatalog();
        this.resourceLoader = this.catalog.getResourceLoader();
        this.schemaBuilder = schemaBuilder;
    }

    public XmlSchemaEncoder(Set<String> mimeTypes, GeoServer gs, FeatureTypeSchemaBuilder schemaBuilder) {
        super(gs, mimeTypes);
        this.catalog = gs.getCatalog();
        this.resourceLoader = this.catalog.getResourceLoader();
        this.schemaBuilder = schemaBuilder;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return this.getOutputFormat();
    }

    protected String getWFSNamespaceURI() {
        return "http://www.opengis.net/wfs";
    }

    @Override
    protected void write(FeatureTypeInfo[] featureTypeInfos, OutputStream output, Operation describeFeatureType) throws IOException {
        if (Dispatcher.REQUEST.get() != null && ((Request)Dispatcher.REQUEST.get()).isSOAP()) {
            output.write(("<wfs:DescribeFeatureTypeResponse xmlns:wfs='" + this.getWFSNamespaceURI() + "'>").getBytes());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.doWrite(featureTypeInfos, bout, describeFeatureType);
            output.write(Base64.encodeBase64((byte[])bout.toByteArray()));
            output.write("</wfs:DescribeFeatureTypeResponse>".getBytes());
        } else {
            this.doWrite(featureTypeInfos, output, describeFeatureType);
        }
    }

    protected void doWrite(FeatureTypeInfo[] featureTypeInfos, OutputStream output, Operation describeFeatureType) throws IOException {
        Object request = describeFeatureType.getParameters()[0];
        DescribeFeatureTypeRequest req = DescribeFeatureTypeRequest.adapt(request);
        XSDSchema schema = this.schemaBuilder.build(featureTypeInfos, req.getBaseURL());
        schema.updateElement();
        String encoding = this.gs.getSettings().getCharset();
        XSDResourceImpl.serialize((OutputStream)output, (Element)schema.getElement(), (String)encoding);
    }

    public static class V10
    extends XmlSchemaEncoder {
        public V10(GeoServer gs) {
            super("XMLSCHEMA", gs, (FeatureTypeSchemaBuilder)new FeatureTypeSchemaBuilder.GML2(gs));
        }

        @Override
        public String getMimeType(Object arg0, Operation arg1) throws ServiceException {
            return "text/xml";
        }
    }

    public static class V11
    extends XmlSchemaEncoder {
        public V11(GeoServer gs) {
            super("text/xml; subtype=gml/3.1.1", gs, (FeatureTypeSchemaBuilder)new FeatureTypeSchemaBuilder.GML3(gs));
        }
    }

    public static class V20
    extends XmlSchemaEncoder {
        static Set<String> MIME_TYPES = new LinkedHashSet<String>();

        public V20(GeoServer gs) {
            super(MIME_TYPES, gs, (FeatureTypeSchemaBuilder)new FeatureTypeSchemaBuilder.GML32(gs));
        }

        @Override
        protected String getWFSNamespaceURI() {
            return "http://www.opengis.net/wfs/2.0";
        }

        static {
            MIME_TYPES.add("text/xml; subtype=gml/3.2");
            MIME_TYPES.add("application/gml+xml; version=3.2");
        }
    }
}

