/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.xml.v1_0_0.WFS;
import org.geotools.gml2.bindings.GML2ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.picocontainer.MutablePicoContainer;
import org.xml.sax.helpers.NamespaceSupport;

public class QueryTypeBinding
extends AbstractComplexBinding {
    WfsFactory wfsfactory;
    NamespaceSupport namespaceSupport;

    public QueryTypeBinding(WfsFactory wfsfactory, NamespaceSupport namespaceSupport) {
        this.wfsfactory = wfsfactory;
        this.namespaceSupport = namespaceSupport;
    }

    public QName getTarget() {
        return WFS.QUERYTYPE;
    }

    public Class getType() {
        return QueryType.class;
    }

    public void initializeChildContext(ElementInstance childInstance, Node node, MutablePicoContainer context) {
        if (node.hasAttribute("srsName")) {
            try {
                CoordinateReferenceSystem crs = GML2ParsingUtils.crs((Node)node);
                if (crs != null) {
                    context.registerComponentInstance(CoordinateReferenceSystem.class, (Object)crs);
                }
            }
            catch (Exception e) {
                throw new WFSException(e, "InvalidParameterValue");
            }
        }
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        QueryType queryType = this.wfsfactory.createQueryType();
        List propertyNames = node.getChildValues(PropertyName.class);
        for (PropertyName propertyName : propertyNames) {
            queryType.getPropertyName().add((Object)propertyName.getPropertyName());
        }
        Filter filter = (Filter)node.getChildValue(Filter.class);
        if (filter == null) {
            filter = Filter.INCLUDE;
        }
        queryType.setFilter(filter);
        queryType.setHandle((String)node.getAttributeValue("handle"));
        ArrayList<Object> typeNameList = new ArrayList<Object>();
        typeNameList.add(node.getAttributeValue("typeName"));
        queryType.setTypeName(typeNameList);
        queryType.setFeatureVersion((String)node.getAttributeValue("featureVersion"));
        if (node.hasAttribute("srsName")) {
            queryType.setSrsName(new URI((String)node.getAttributeValue("srsName")));
        }
        return queryType;
    }
}

