/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.wfs.DescribeFeatureType;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.kvp.DescribeFeatureTypeKvpRequestReader;
import org.geoserver.wfs.request.DescribeFeatureTypeRequest;
import org.geoserver.wfs.xml.v1_1_0.XmlSchemaEncoder;
import org.geotools.util.logging.Logging;

public class WFSURIHandler
extends URIHandlerImpl {
    static final Logger LOGGER = Logging.getLogger(WFSURIHandler.class);
    static final Boolean DISABLED = Boolean.getBoolean(WFSURIHandler.class.getName() + ".disabled");
    static final List<InetAddress> ADDRESSES = new ArrayList<InetAddress>();
    GeoServer geoServer;

    public WFSURIHandler(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public boolean canHandle(URI uri) {
        KvpMap kv;
        String q;
        if (DISABLED.booleanValue()) {
            return false;
        }
        return this.uriIsReflective(uri) && (q = uri.query()) != null && !"".equals(q.trim()) && ("DescribeFeatureType".equalsIgnoreCase((String)(kv = this.parseQueryString(q)).get((Object)"REQUEST")) || uri.path().endsWith("DescribeFeatureType"));
    }

    private KvpMap parseQueryString(String q) {
        return KvpUtils.normalize((Map)KvpUtils.parseQueryString((String)("?" + q)));
    }

    private boolean uriIsReflective(URI uri) {
        String proxyBaseUrl = this.geoServer.getGlobal().getProxyBaseUrl();
        if (proxyBaseUrl != null) {
            try {
                URI proxyBaseUri = URI.createURI((String)proxyBaseUrl);
                if (uri.host().equals(proxyBaseUri.host())) {
                    return true;
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.fine("Unable to parse proxy base url to a uri: " + proxyBaseUrl);
            }
        }
        for (InetAddress add : ADDRESSES) {
            if (!uri.host().equals(add.getHostAddress()) && !uri.host().equals(add.getHostName())) continue;
            return true;
        }
        return false;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        Catalog catalog = this.geoServer.getCatalog();
        try {
            KvpMap kv = this.parseQueryString(uri.query());
            WFSInfo.Version ver = WFSInfo.Version.negotiate((String)kv.get((Object)"VERSION"));
            if (ver == null) {
                ver = WFSInfo.Version.latest();
            }
            DescribeFeatureTypeKvpRequestReader dftReqReader = null;
            switch (ver) {
                case V_10: 
                case V_11: {
                    dftReqReader = new DescribeFeatureTypeKvpRequestReader(catalog);
                    break;
                }
                default: {
                    dftReqReader = new org.geoserver.wfs.kvp.v2_0.DescribeFeatureTypeKvpRequestReader(catalog);
                }
            }
            KvpMap parsed = new KvpMap((Map)kv);
            KvpUtils.parse((Map)parsed);
            DescribeFeatureTypeRequest request = DescribeFeatureTypeRequest.adapt(dftReqReader.read(dftReqReader.createRequest(), (Map)parsed, (Map)kv));
            request.setBaseUrl(uri.scheme() + "://" + uri.host() + ":" + uri.port() + uri.path());
            DescribeFeatureType dft = new DescribeFeatureType((WFSInfo)this.geoServer.getService(WFSInfo.class), catalog);
            FeatureTypeInfo[] featureTypes = dft.run(request);
            XmlSchemaEncoder schemaEncoder = null;
            switch (ver) {
                case V_10: {
                    schemaEncoder = new XmlSchemaEncoder.V10(this.geoServer);
                    break;
                }
                case V_11: {
                    schemaEncoder = new XmlSchemaEncoder.V11(this.geoServer);
                    break;
                }
                default: {
                    schemaEncoder = new XmlSchemaEncoder.V20(this.geoServer);
                }
            }
            Operation op = new Operation("DescribeFeatureType", new Service("WFS", null, null, null), null, new Object[]{request.getAdaptee()});
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            schemaEncoder.write((Object)featureTypes, (OutputStream)bout, op);
            return new ByteArrayInputStream(bout.toByteArray());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to handle DescribeFeatureType uri: " + uri, e);
            return super.createInputStream(uri, options);
        }
    }

    static {
        if (!DISABLED.booleanValue()) {
            Enumeration<NetworkInterface> e = null;
            try {
                e = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException ex) {
                LOGGER.log(Level.WARNING, "Unable to determine network interface info", ex);
            }
            while (e != null && e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                Enumeration<InetAddress> f = ni.getInetAddresses();
                while (f.hasMoreElements()) {
                    InetAddress add = f.nextElement();
                    add.getHostName();
                    ADDRESSES.add(add);
                }
            }
        }
    }
}

