/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.xml.ApplicationSchemaConfiguration;
import org.geoserver.wfs.xml.ApplicationSchemaXSD;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.wfs.WFS;
import org.geotools.wfs.v1_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.feature.simple.SimpleFeatureType;

public class GML2OutputFormat2
extends WFSGetFeatureOutputFormat {
    Catalog catalog;
    GeoServerResourceLoader resourceLoader;

    public GML2OutputFormat2(GeoServer gs) {
        super(gs, new HashSet<Object>(Arrays.asList("gml2", "text/xml; subtype=gml/2.1.2")));
        this.catalog = gs.getCatalog();
        this.resourceLoader = this.catalog.getResourceLoader();
    }

    @Override
    public String getMimeType(Object value, Operation operation) {
        return "text/xml; subtype=gml/2.1.2";
    }

    @Override
    public String getCapabilitiesElementName() {
        return "GML2";
    }

    @Override
    protected void write(FeatureCollectionResponse results, OutputStream output, Operation getFeature) throws ServiceException, IOException {
        GetFeatureRequest gft = GetFeatureRequest.adapt(getFeature.getParameters()[0]);
        List<FeatureCollection> featureCollections = results.getFeature();
        MultiHashMap ns2metas = new MultiHashMap();
        for (SimpleFeatureCollection simpleFeatureCollection : featureCollections) {
            SimpleFeatureType featureType = (SimpleFeatureType)simpleFeatureCollection.getSchema();
            String namespaceURI = featureType.getName().getNamespaceURI();
            FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(namespaceURI, featureType.getTypeName());
            if (meta == null) {
                throw new WFSException((RequestObject)gft, "Could not find feature type " + namespaceURI + ":" + featureType.getTypeName() + " in the GeoServer catalog");
            }
            NamespaceInfo ns = this.catalog.getNamespaceByURI(namespaceURI);
            ns2metas.put((Object)ns, (Object)meta);
        }
        Collection featureTypes = ns2metas.values();
        ApplicationSchemaXSD applicationSchemaXSD = new ApplicationSchemaXSD(null, this.catalog, gft.getBaseUrl(), (WFS)org.geotools.wfs.v1_0.WFS.getInstance(), featureTypes);
        ApplicationSchemaConfiguration configuration = new ApplicationSchemaConfiguration(applicationSchemaXSD, (org.geotools.wfs.WFSConfiguration)new WFSConfiguration());
        Encoder encoder = new Encoder((Configuration)configuration);
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.buildSchemaURL((String)gft.getBaseUrl(), (String)"wfs/1.0.0/WFS-basic.xsd"));
        Map params = ResponseUtils.params((String[])new String[]{"service", "WFS", "version", "1.0.0", "request", "DescribeFeatureType"});
        for (Map.Entry entry : ns2metas.entrySet()) {
            NamespaceInfo ns = (NamespaceInfo)entry.getKey();
            String namespaceURI = ns.getURI();
            Collection metas = (Collection)entry.getValue();
            StringBuffer typeNames = new StringBuffer();
            Iterator m = metas.iterator();
            while (m.hasNext()) {
                FeatureTypeInfo meta = (FeatureTypeInfo)m.next();
                typeNames.append(meta.getPrefixedName());
                if (!m.hasNext()) continue;
                typeNames.append(",");
            }
            params.put("typeName", typeNames.toString());
            encoder.setSchemaLocation(namespaceURI, ResponseUtils.buildURL((String)gft.getBaseUrl(), (String)"wfs", (Map)params, (URLMangler.URLType)URLMangler.URLType.RESOURCE));
        }
        encoder.encode((Object)results.getAdaptee(), org.geotools.wfs.v1_0.WFS.FeatureCollection, output);
    }
}

