/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.data.util.IOUtils;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.response.RemappingFeatureCollection;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v1_1.WFS;
import org.geotools.wfs.v1_1.WFSConfiguration;
import org.geotools.xml.Encoder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ShapeZipOutputFormat
extends WFSGetFeatureOutputFormat
implements ApplicationContextAware {
    private static final Logger LOGGER = Logging.getLogger(ShapeZipOutputFormat.class);
    public static final String GS_SHAPEFILE_CHARSET = "GS-SHAPEFILE-CHARSET";
    public static final String SHAPE_ZIP_DEFAULT_PRJ_IS_ESRI = "SHAPE-ZIP_DEFAULT_PRJ_IS_ESRI";
    private static final Configuration templateConfig = new Configuration();
    private ApplicationContext applicationContext;
    private Catalog catalog;
    private GeoServerResourceLoader resourceLoader;

    public ShapeZipOutputFormat() {
        this((GeoServer)GeoServerExtensions.bean(GeoServer.class), (Catalog)GeoServerExtensions.bean((String)"catalog"), (GeoServerResourceLoader)GeoServerExtensions.bean((String)"resourceLoader"));
    }

    public ShapeZipOutputFormat(GeoServer gs, Catalog catalog, GeoServerResourceLoader resourceLoader) {
        super(gs, "SHAPE-ZIP");
        this.catalog = catalog;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/zip";
    }

    @Override
    public String getCapabilitiesElementName() {
        return "SHAPE-ZIP";
    }

    @Override
    protected boolean canHandleInternal(Operation operation) {
        return true;
    }

    public String getPreferredDisposition(Object value, Operation operation) {
        return "attachment";
    }

    public String getAttachmentFileName(Object value, Operation operation) {
        SimpleFeatureCollection fc = (SimpleFeatureCollection)((FeatureCollectionResponse)value).getFeature().get(0);
        FeatureTypeInfo ftInfo = this.getFeatureTypeInfo(fc);
        String filename = null;
        GetFeatureRequest request = GetFeatureRequest.adapt(operation.getParameters()[0]);
        if (request != null) {
            Map formatOptions = request.getFormatOptions();
            filename = (String)formatOptions.get("FILENAME");
        }
        if (filename == null) {
            filename = new FileNameSource(((Object)((Object)this)).getClass()).getZipName(ftInfo);
        }
        if (filename == null) {
            filename = ftInfo.getName();
        }
        return filename + (filename.endsWith(".zip") ? "" : ".zip");
    }

    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        ArrayList<SimpleFeatureCollection> collections = new ArrayList<SimpleFeatureCollection>();
        collections.addAll(featureCollection.getFeature());
        Charset charset = this.getShapefileCharset(getFeature);
        this.write(collections, charset, output, GetFeatureRequest.adapt(getFeature.getParameters()[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<SimpleFeatureCollection> collections, Charset charset, OutputStream output, GetFeatureRequest request) throws IOException, ServiceException {
        File tempDir = IOUtils.createTempDirectory((String)"shpziptemp");
        try {
            boolean shapefileCreated = false;
            for (SimpleFeatureCollection curCollection : collections) {
                if (((SimpleFeatureType)curCollection.getSchema()).getGeometryDescriptor() == null) {
                    throw new WFSException((RequestObject)request, "Cannot write geometryless shapefiles, yet " + curCollection.getSchema() + " has no geometry field");
                }
                Class geomType = ((SimpleFeatureType)curCollection.getSchema()).getGeometryDescriptor().getType().getBinding();
                if (GeometryCollection.class.equals((Object)geomType) || Geometry.class.equals((Object)geomType)) {
                    shapefileCreated |= this.writeCollectionToShapefiles(curCollection, tempDir, charset, request);
                    continue;
                }
                this.writeCollectionToShapefile(curCollection, tempDir, charset, request);
                shapefileCreated = true;
            }
            if (!shapefileCreated) {
                SimpleFeatureCollection fc = collections.get(0);
                fc = this.remapCollectionSchema(fc, Point.class);
                this.writeCollectionToShapefile(fc, tempDir, charset, request);
                this.createEmptyZipWarning(tempDir);
            }
            this.createRequestDump(tempDir, request, collections.get(0));
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".shp") || name.endsWith(".shx") || name.endsWith(".dbf") || name.endsWith(".prj") || name.endsWith(".cst") || name.endsWith(".txt");
                }
            };
            ZipOutputStream zipOut = new ZipOutputStream(output);
            IOUtils.zipDirectory((File)tempDir, (ZipOutputStream)zipOut, (FilenameFilter)filter);
            zipOut.finish();
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)tempDir);
            }
            catch (IOException e) {
                LOGGER.warning("Could not delete temp directory: " + tempDir.getAbsolutePath() + " due to: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRequestDump(File tempDir, GetFeatureRequest gft, SimpleFeatureCollection fc) {
        block10: {
            Request request = (Request)Dispatcher.REQUEST.get();
            if (request == null || gft == null) {
                return;
            }
            FeatureTypeInfo ftInfo = this.getFeatureTypeInfo(fc);
            String fileName = new FileNameSource(((Object)((Object)this)).getClass()).getRequestDumpName(ftInfo) + ".txt";
            File target = new File(tempDir, fileName);
            try {
                if (request.isGet()) {
                    HttpServletRequest httpRequest = request.getHttpRequest();
                    String baseUrl = ResponseUtils.baseURL((HttpServletRequest)httpRequest);
                    String path = request.getPath();
                    String mangledUrl = ResponseUtils.buildURL((String)baseUrl, (String)path, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                    StringBuilder url = new StringBuilder();
                    String parameters = httpRequest.getQueryString();
                    url.append(mangledUrl).append("?").append(parameters);
                    FileUtils.writeStringToFile((File)target, (String)url.toString());
                    break block10;
                }
                WFSConfiguration cfg = null;
                QName elementName = null;
                if (gft.getVersion().equals("1.1.0")) {
                    cfg = new WFSConfiguration();
                    elementName = WFS.GetFeature;
                } else {
                    cfg = new org.geotools.wfs.v1_0.WFSConfiguration();
                    elementName = org.geotools.wfs.v1_0.WFS.GetFeature;
                }
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(target);
                    Encoder encoder = new Encoder((org.geotools.xml.Configuration)cfg);
                    encoder.setIndenting(true);
                    encoder.setIndentSize(2);
                    encoder.encode((Object)gft, elementName, (OutputStream)fos);
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            catch (IOException e) {
                throw new WFSException((RequestObject)gft, "Failed to dump the WFS request");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmptyZipWarning(File tempDir) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new File(tempDir, "README.TXT"));
            pw.print("The query result is empty, and the geometric type of the features is unknwon:an empty point shapefile has been created to fill the zip file");
        }
        finally {
            pw.close();
        }
    }

    private void writeCollectionToShapefile(SimpleFeatureCollection c, File tempDir, Charset charset, GetFeatureRequest request) {
        FeatureTypeInfo ftInfo = this.getFeatureTypeInfo(c);
        c = this.remapCollectionSchema(c, null);
        SimpleFeatureType schema = (SimpleFeatureType)c.getSchema();
        String fileName = new FileNameSource(((Object)((Object)this)).getClass()).getShapeName(ftInfo, null);
        if (!fileName.equals(schema.getTypeName())) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.init((SimpleFeatureType)c.getSchema());
            tb.setName(fileName);
            SimpleFeatureType renamed = tb.buildFeatureType();
            c = new RetypingFeatureCollection(c, renamed);
        }
        SimpleFeatureStore fstore = null;
        ShapefileDataStore dstore = null;
        try {
            Map<String, String> attributeMappings = this.createAttributeMappings((SimpleFeatureType)c.getSchema());
            RemappingFeatureCollection remapped = new RemappingFeatureCollection(c, attributeMappings);
            SimpleFeatureType remappedSchema = (SimpleFeatureType)remapped.getSchema();
            dstore = this.buildStore(tempDir, charset, remappedSchema);
            fstore = (SimpleFeatureStore)dstore.getFeatureSource();
            RetypingFeatureCollection retyped = new RetypingFeatureCollection((SimpleFeatureCollection)remapped, (SimpleFeatureType)fstore.getSchema());
            fstore.addFeatures((FeatureCollection)retyped);
            this.changeWKTFormatIfFileFormatIsESRI(tempDir, request, fileName, remappedSchema);
        }
        catch (FactoryException fe) {
            LOGGER.log(Level.WARNING, "Error while getting EPSG code from FeatureType", fe);
            throw new ServiceException((Throwable)fe);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error while writing featuretype '" + schema.getTypeName() + "' to shapefile.", ioe);
            throw new ServiceException((Throwable)ioe);
        }
        finally {
            if (dstore != null) {
                dstore.dispose();
            }
        }
    }

    private FeatureTypeInfo getFeatureTypeInfo(SimpleFeatureCollection c) {
        FeatureTypeInfo ftInfo = this.catalog.getFeatureTypeByName(((SimpleFeatureType)c.getSchema()).getName());
        if (ftInfo == null) {
            SimpleFeatureSource featureSource = DataUtilities.source((FeatureCollection)c);
            CatalogBuilder catalogBuilder = new CatalogBuilder(this.catalog);
            catalogBuilder.setStore((StoreInfo)catalogBuilder.buildDataStore(((SimpleFeatureType)c.getSchema()).getName().getLocalPart()));
            ftInfo = catalogBuilder.buildFeatureType((FeatureSource)featureSource);
        }
        return ftInfo;
    }

    private void changeWKTFormatIfFileFormatIsESRI(File tempDir, GetFeatureRequest request, String fileName, SimpleFeatureType remappedSchema) throws FactoryException, IOException, FileNotFoundException {
        WFSInfo bean;
        MetadataMap metadata;
        Boolean defaultIsEsri;
        boolean useEsriFormat = false;
        if (request == null) {
            return;
        }
        Map formatOptions = request.getFormatOptions();
        String requestedPrjFileFormat = (String)formatOptions.get("PRJFILEFORMAT");
        useEsriFormat = null == requestedPrjFileFormat ? (defaultIsEsri = (Boolean)(metadata = (bean = (WFSInfo)this.gs.getService(WFSInfo.class)).getMetadata()).get(SHAPE_ZIP_DEFAULT_PRJ_IS_ESRI, Boolean.class)) != null && defaultIsEsri != false : "ESRI".equalsIgnoreCase(requestedPrjFileFormat);
        if (useEsriFormat) {
            this.replaceOGCPrjFileByESRIPrjFile(tempDir, fileName, remappedSchema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceOGCPrjFileByESRIPrjFile(File tempDir, String fileName, SimpleFeatureType remappedSchema) throws FactoryException, IOException, FileNotFoundException {
        Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)remappedSchema.getGeometryDescriptor().getCoordinateReferenceSystem(), (boolean)true);
        if (epsgCode == null) {
            LOGGER.info("Can't find the EPSG code for the shapefile CRS");
            return;
        }
        File file = this.resourceLoader.find(new String[]{"user_projections", "esri.properties"});
        if (file != null && file.exists()) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            String data = (String)properties.get(epsgCode.toString());
            if (data != null) {
                File prjShapeFile = new File(tempDir, fileName + ".prj");
                prjShapeFile.delete();
                BufferedWriter out = new BufferedWriter(new FileWriter(prjShapeFile));
                try {
                    out.write(data);
                }
                finally {
                    out.close();
                }
            } else {
                LOGGER.info("Requested shapefile with ESRI WKT .prj format but couldn't find an entry for ESPG code " + epsgCode + " in esri.properties");
            }
        } else {
            LOGGER.info("Requested shapefile with ESRI WKT .prj format but the esri.properties file does not exist in the user_projections directory");
        }
    }

    SimpleFeatureCollection remapCollectionSchema(SimpleFeatureCollection fc, Class targetGeometry) {
        SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
        if (targetGeometry != null) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
                if (!(ad instanceof GeometryDescriptor)) {
                    tb.add(ad);
                    continue;
                }
                Class geomType = ad.getType().getBinding();
                if (geomType.equals(Geometry.class) || geomType.equals(GeometryCollection.class)) {
                    tb.add(ad.getName().getLocalPart(), targetGeometry, ((GeometryDescriptor)ad).getCoordinateReferenceSystem());
                    continue;
                }
                tb.add(ad);
            }
            tb.setName(((SimpleFeatureType)fc.getSchema()).getName());
            SimpleFeatureType retyped = tb.buildFeatureType();
            fc = new RetypingFeatureCollection(fc, retyped);
        }
        Map<String, String> attributeMappings = this.createAttributeMappings(schema);
        return new RemappingFeatureCollection(fc, attributeMappings);
    }

    private Map<String, String> createAttributeMappings(SimpleFeatureType schema) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> usedFieldNames = new HashSet<String>();
        usedFieldNames.add("the_geom");
        for (AttributeDescriptor attDesc : schema.getAttributeDescriptors()) {
            if (attDesc instanceof GeometryDescriptor) {
                result.put(attDesc.getLocalName(), "the_geom");
                continue;
            }
            String name = attDesc.getLocalName();
            result.put(attDesc.getLocalName(), this.getShapeCompatibleName(usedFieldNames, name));
        }
        return result;
    }

    String getShapeCompatibleName(Set<String> usedFieldNames, String name) {
        if (name.length() > 10) {
            name = name.substring(0, 10);
        }
        int counter = 0;
        while (usedFieldNames.contains(name)) {
            String postfix = counter++ + "";
            name = name.substring(0, name.length() - postfix.length()) + postfix;
        }
        usedFieldNames.add(name);
        return name;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeCollectionToShapefiles(SimpleFeatureCollection c, File tempDir, Charset charset, GetFeatureRequest request) {
        Iterator i$;
        IOException stored;
        FeatureTypeInfo ftInfo = this.getFeatureTypeInfo(c);
        c = this.remapCollectionSchema(c, null);
        SimpleFeatureType schema = (SimpleFeatureType)c.getSchema();
        boolean shapefileCreated = false;
        HashMap<Class, StoreWriter> writers = new HashMap<Class, StoreWriter>();
        try {
            SimpleFeatureIterator it = c.features();
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                if (f.getDefaultGeometry() == null) {
                    LOGGER.warning("Skipping " + f.getID() + " as its geometry is null");
                    continue;
                }
                FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getFeatureWriter(ftInfo, f, writers, tempDir, charset);
                SimpleFeature fw = (SimpleFeature)writer.next();
                for (AttributeDescriptor d : fw.getFeatureType().getAttributeDescriptors()) {
                    fw.setAttribute(d.getLocalName(), f.getAttribute(d.getLocalName()));
                }
                fw.setDefaultGeometry(f.getDefaultGeometry());
                writer.write();
                shapefileCreated = true;
                ((SimpleFeatureType)writer.getFeatureType()).getName().getLocalPart();
                String geometryType = (String)this.getGeometryType((Geometry)f.getDefaultGeometry()).get("geometryType");
                String fileName = new FileNameSource(((Object)((Object)this)).getClass()).getShapeName(ftInfo, geometryType);
                this.changeWKTFormatIfFileFormatIsESRI(tempDir, request, fileName, schema);
            }
            stored = null;
            i$ = writers.values().iterator();
        }
        catch (FactoryException fe) {
            try {
                LOGGER.log(Level.WARNING, "Error while getting EPSG code from FeatureType", fe);
                throw new ServiceException((Throwable)fe);
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "Error while writing featuretype '" + schema.getTypeName() + "' to shapefile.", ioe);
                    throw new ServiceException((Throwable)ioe);
                }
            }
            catch (Throwable throwable) {
                IOException stored2 = null;
                for (StoreWriter sw : writers.values()) {
                    try {
                        sw.writer.close();
                        sw.dstore.dispose();
                    }
                    catch (IOException e) {
                        stored2 = e;
                    }
                }
                if (stored2 != null) {
                    throw new ServiceException(stored2);
                }
                throw throwable;
            }
        }
        while (i$.hasNext()) {
            StoreWriter sw = (StoreWriter)i$.next();
            try {
                sw.writer.close();
                sw.dstore.dispose();
            }
            catch (IOException e) {
                stored = e;
            }
        }
        if (stored != null) {
            throw new ServiceException(stored);
        }
        return shapefileCreated;
    }

    private FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(FeatureTypeInfo ftInfo, SimpleFeature f, Map<Class, StoreWriter> writers, File tempDir, Charset charset) throws IOException {
        Map<String, Object> map = this.getGeometryType((Geometry)f.getDefaultGeometry());
        Class target = (Class)map.get("target");
        String geometryType = (String)map.get("geometryType");
        StoreWriter storeWriter = writers.get(target);
        if (storeWriter == null) {
            SimpleFeatureType original = f.getFeatureType();
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor d : original.getAttributeDescriptors()) {
                if (Geometry.class.isAssignableFrom(d.getType().getBinding())) {
                    GeometryDescriptor gd = (GeometryDescriptor)d;
                    builder.add(gd.getLocalName(), target, gd.getCoordinateReferenceSystem());
                    builder.setDefaultGeometry(gd.getLocalName());
                    continue;
                }
                builder.add(d);
            }
            builder.setNamespaceURI(original.getName().getURI());
            String fileName = new FileNameSource(((Object)((Object)this)).getClass()).getShapeName(ftInfo, geometryType);
            builder.setName(fileName);
            SimpleFeatureType retyped = builder.buildFeatureType();
            ShapefileDataStore dstore = this.buildStore(tempDir, charset, retyped);
            storeWriter = new StoreWriter();
            storeWriter.dstore = dstore;
            storeWriter.writer = dstore.getFeatureWriter(retyped.getTypeName(), Transaction.AUTO_COMMIT);
            writers.put(target, storeWriter);
        }
        return storeWriter.writer;
    }

    private Map<String, Object> getGeometryType(Geometry g) {
        Class<Point> target;
        String geometryType = null;
        if (g instanceof Point) {
            target = Point.class;
            geometryType = "Point";
        } else if (g instanceof MultiPoint) {
            target = MultiPoint.class;
            geometryType = "MPoint";
        } else if (g instanceof MultiPolygon || g instanceof Polygon) {
            target = MultiPolygon.class;
            geometryType = "Polygon";
        } else if (g instanceof LineString || g instanceof MultiLineString) {
            target = MultiLineString.class;
            geometryType = "Line";
        } else {
            throw new RuntimeException("This should never happen, there's a bug in the SHAPE-ZIP output format. I got a geometry of type " + g.getClass());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("target", target);
        map.put("geometryType", geometryType);
        return map;
    }

    private Charset getShapefileCharset(Operation getFeature) {
        Charset result = null;
        GetFeatureRequest gft = GetFeatureRequest.adapt(getFeature.getParameters()[0]);
        if (gft.getFormatOptions() != null && gft.getFormatOptions().get("CHARSET") != null) {
            result = (Charset)gft.getFormatOptions().get("CHARSET");
        } else {
            String charsetName = GeoServerExtensions.getProperty((String)GS_SHAPEFILE_CHARSET, (ApplicationContext)this.applicationContext);
            if (charsetName != null) {
                result = Charset.forName(charsetName);
            }
        }
        return result != null ? result : Charset.forName("ISO-8859-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShapefileDataStore buildStore(File tempDir, Charset charset, SimpleFeatureType schema) throws MalformedURLException, FileNotFoundException, IOException {
        File file = new File(tempDir, schema.getTypeName() + ".shp");
        ShapefileDataStore sfds = new ShapefileDataStore(file.toURL());
        sfds.setStringCharset(charset);
        File charsetFile = new File(tempDir, schema.getTypeName() + ".cst");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(charsetFile);
            pw.write(charset.name());
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        try {
            sfds.createSchema(schema);
        }
        catch (NullPointerException e) {
            LOGGER.warning("Error in shapefile schema. It is possible you don't have a geometry set in the output. \nPlease specify a <wfs:PropertyName>geom_column_name</wfs:PropertyName> in the request");
            throw new ServiceException("Error in shapefile schema. It is possible you don't have a geometry set in the output.");
        }
        try {
            if (schema.getCoordinateReferenceSystem() != null) {
                sfds.forceSchemaCRS(schema.getCoordinateReferenceSystem());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not properly create the .prj file", e);
        }
        return sfds;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    static class FileNameSource {
        private Class clazz;

        public FileNameSource(Class clazz) {
            this.clazz = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties processTemplate(FeatureTypeInfo ftInfo, String geometryType) {
            try {
                GeoServerTemplateLoader templateLoader = new GeoServerTemplateLoader(this.clazz);
                templateLoader.setFeatureType(ftInfo);
                Template template = null;
                Configuration configuration = templateConfig;
                synchronized (configuration) {
                    templateConfig.setTemplateLoader((TemplateLoader)templateLoader);
                    template = templateConfig.getTemplate("shapezip.ftl");
                }
                Date timestamp = Dispatcher.REQUEST.get() != null ? ((Request)Dispatcher.REQUEST.get()).getTimestamp() : new Date();
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("typename", this.getTypeName(ftInfo));
                context.put("workspace", ftInfo.getNamespace().getPrefix());
                context.put("geometryType", geometryType == null ? "" : geometryType);
                context.put("timestamp", timestamp);
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
                Calendar cal = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
                format.setCalendar(cal);
                context.put("iso_timestamp", format.format(timestamp));
                StringWriter sw = new StringWriter();
                template.process(context, (Writer)sw);
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(sw.toString().getBytes()));
                return props;
            }
            catch (Exception e) {
                throw new WFSException("Failed to process the file name template", (Throwable)e);
            }
        }

        private String getTypeName(FeatureTypeInfo ftInfo) {
            return ftInfo.getName().replace(".", "_");
        }

        public String getZipName(FeatureTypeInfo ftInfo) {
            Properties props = this.processTemplate(ftInfo, null);
            String filename = props.getProperty("zip");
            if (filename == null) {
                filename = this.getTypeName(ftInfo);
            }
            return filename;
        }

        public String getShapeName(FeatureTypeInfo ftInfo, String geometryType) {
            Properties props = this.processTemplate(ftInfo, geometryType);
            String filename = props.getProperty("shp");
            if (filename == null) {
                filename = this.getTypeName(ftInfo) + geometryType;
            }
            return filename;
        }

        public String getRequestDumpName(FeatureTypeInfo ftInfo) {
            Properties props = this.processTemplate(ftInfo, null);
            String filename = props.getProperty("txt");
            if (filename == null) {
                filename = this.getTypeName(ftInfo);
            }
            return filename;
        }
    }

    private static class StoreWriter {
        DataStore dstore;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer;

        private StoreWriter() {
        }
    }
}

