/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.json.JSONException;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.response.GeoJSONBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoJSONOutputFormat
extends WFSGetFeatureOutputFormat {
    private final Logger LOGGER = Logging.getLogger((String)((Object)((Object)this)).getClass().toString());
    public static final String FORMAT = "json";

    public GeoJSONOutputFormat(GeoServer gs) {
        super(gs, FORMAT);
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        GetFeatureRequest gft = GetFeatureRequest.adapt(operation.getParameters()[0]);
        String callback = (String)gft.getFormatOptions().get("CALLBACK");
        if (callback != null && !"".equals(callback)) {
            return "text/javascript";
        }
        return "application/json";
    }

    @Override
    public String getCapabilitiesElementName() {
        return "GEOJSON";
    }

    protected String getContentDisposition(FeatureCollectionResponse featureCollection) {
        StringBuffer sb = new StringBuffer();
        for (FeatureCollection fc : featureCollection.getFeature()) {
            sb.append(fc.getSchema().getName().getLocalPart() + "_");
        }
        sb.setLength(sb.length() - 1);
        return "inline; filename=" + sb.toString() + ".txt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        WFSInfo wfs = this.getInfo();
        BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(output, wfs.getGeoServer().getSettings().getCharset()));
        GetFeatureRequest gft = GetFeatureRequest.adapt(getFeature.getParameters()[0]);
        String callback = (String)gft.getFormatOptions().get("CALLBACK");
        if (callback != null && !"".equals(callback)) {
            outWriter.write(callback + "(");
        }
        GeoJSONBuilder jsonWriter = new GeoJSONBuilder(outWriter);
        List<FeatureCollection> resultsList = featureCollection.getFeature();
        this.LOGGER.info("about to encode JSON");
        boolean featureBounding = wfs.isFeatureBounding();
        boolean hasGeom = false;
        try {
            NamedIdentifier namedIdent;
            String csStr;
            Set ids;
            jsonWriter.object().key("type").value((Object)"FeatureCollection");
            jsonWriter.key("features");
            jsonWriter.array();
            CoordinateReferenceSystem crs = null;
            for (int i = 0; i < resultsList.size(); ++i) {
                FeatureCollection collection = resultsList.get(i);
                FeatureIterator iterator = collection.features();
                try {
                    while (iterator.hasNext()) {
                        Object value;
                        int j;
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        jsonWriter.object();
                        jsonWriter.key("type").value((Object)"Feature");
                        jsonWriter.key("id").value((Object)feature.getID());
                        SimpleFeatureType fType = feature.getFeatureType();
                        List types = fType.getAttributeDescriptors();
                        GeometryDescriptor defaultGeomType = fType.getGeometryDescriptor();
                        if (crs == null && defaultGeomType != null) {
                            crs = fType.getGeometryDescriptor().getCoordinateReferenceSystem();
                        }
                        jsonWriter.key("geometry");
                        Geometry aGeom = (Geometry)feature.getDefaultGeometry();
                        if (aGeom == null) {
                            for (j = 0; j < types.size() && aGeom == null; ++j) {
                                value = feature.getAttribute(j);
                                if (value == null || !(value instanceof Geometry)) continue;
                                aGeom = (Geometry)value;
                            }
                        }
                        if (aGeom != null) {
                            jsonWriter.writeGeom(aGeom);
                            hasGeom = true;
                        } else {
                            jsonWriter.value(null);
                        }
                        if (defaultGeomType != null) {
                            jsonWriter.key("geometry_name").value((Object)defaultGeomType.getLocalName());
                        }
                        jsonWriter.key("properties");
                        jsonWriter.object();
                        for (j = 0; j < types.size(); ++j) {
                            value = feature.getAttribute(j);
                            AttributeDescriptor ad = (AttributeDescriptor)types.get(j);
                            if (value != null) {
                                if (value instanceof Geometry) {
                                    if (ad.equals(defaultGeomType)) continue;
                                    jsonWriter.key(ad.getLocalName());
                                    jsonWriter.writeGeom((Geometry)value);
                                    continue;
                                }
                                jsonWriter.key(ad.getLocalName());
                                jsonWriter.value(value);
                                continue;
                            }
                            jsonWriter.key(ad.getLocalName());
                            jsonWriter.value(null);
                        }
                        ReferencedEnvelope refenv = new ReferencedEnvelope(feature.getBounds());
                        if (featureBounding && !refenv.isEmpty()) {
                            jsonWriter.writeBoundingBox((Envelope)refenv);
                        }
                        jsonWriter.endObject();
                        jsonWriter.endObject();
                    }
                    continue;
                }
                finally {
                    collection.close(iterator);
                }
            }
            jsonWriter.endArray();
            if (crs != null && (ids = crs.getIdentifiers()) != null && ids.size() > 0 && (csStr = (namedIdent = (NamedIdentifier)ids.iterator().next()).getCodeSpace().toUpperCase()).equals("EPSG")) {
                jsonWriter.key("crs");
                jsonWriter.object();
                jsonWriter.key("type").value((Object)csStr);
                jsonWriter.key("properties");
                jsonWriter.object();
                jsonWriter.key("code");
                jsonWriter.value(namedIdent.getCode());
                jsonWriter.endObject();
                jsonWriter.endObject();
            }
            if (hasGeom && featureBounding) {
                ReferencedEnvelope e = null;
                for (int i = 0; i < resultsList.size(); ++i) {
                    FeatureCollection collection = resultsList.get(i);
                    if (e == null) {
                        e = collection.getBounds();
                        continue;
                    }
                    e.expandToInclude((Envelope)collection.getBounds());
                }
                if (e != null) {
                    jsonWriter.writeBoundingBox((Envelope)e);
                }
            }
            jsonWriter.endObject();
            ((Writer)outWriter).flush();
            if (callback != null && !"".equals(callback)) {
                outWriter.write(")");
                ((Writer)outWriter).flush();
            }
        }
        catch (JSONException jsonException) {
            ServiceException serviceException = new ServiceException("Error: " + jsonException.getMessage());
            serviceException.initCause((Throwable)jsonException);
            throw serviceException;
        }
    }
}

