/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.sql.Time;
import java.text.NumberFormat;
import java.util.Locale;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.type.DateUtil;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class CSVOutputFormat
extends WFSGetFeatureOutputFormat {
    public CSVOutputFormat(GeoServer gs) {
        super(gs, "csv");
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/csv";
    }

    public String getPreferredDisposition(Object value, Operation operation) {
        return "attachment";
    }

    public String getAttachmentFileName(Object value, Operation operation) {
        GetFeatureRequest request = GetFeatureRequest.adapt(operation.getParameters()[0]);
        String outputFileName = request.getQueries().get(0).getTypeNames().get(0).getLocalPart();
        return outputFileName + ".csv";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(output));
        SimpleFeatureCollection fc = (SimpleFeatureCollection)featureCollection.getFeature().get(0);
        SimpleFeatureType ft = (SimpleFeatureType)fc.getSchema();
        w.write("FID,");
        for (int i = 0; i < ft.getAttributeCount(); ++i) {
            AttributeDescriptor ad = ft.getDescriptor(i);
            w.write(this.prepCSVField(ad.getLocalName()));
            if (i >= ft.getAttributeCount() - 1) continue;
            w.write(",");
        }
        w.write("\r\n");
        NumberFormat coordFormatter = NumberFormat.getInstance(Locale.US);
        coordFormatter.setMaximumFractionDigits(this.getInfo().getGeoServer().getSettings().getNumDecimals());
        coordFormatter.setGroupingUsed(false);
        SimpleFeatureIterator i = fc.features();
        try {
            while (i.hasNext()) {
                SimpleFeature f = (SimpleFeature)i.next();
                w.write(this.prepCSVField(f.getID()));
                w.write(",");
                for (int j = 0; j < f.getAttributeCount(); ++j) {
                    Object att = f.getAttribute(j);
                    if (att != null) {
                        String value = null;
                        value = att instanceof Number ? coordFormatter.format(att) : (att instanceof java.util.Date ? (att instanceof Date ? DateUtil.serializeSqlDate((Date)((Date)att)) : (att instanceof Time ? DateUtil.serializeSqlTime((Time)((Time)att)) : DateUtil.serializeDateTime((java.util.Date)((java.util.Date)att)))) : att.toString());
                        w.write(this.prepCSVField(value));
                    }
                    if (j >= f.getAttributeCount() - 1) continue;
                    w.write(",");
                }
                w.write("\r\n");
            }
        }
        finally {
            fc.close((FeatureIterator)i);
        }
        w.flush();
    }

    private String prepCSVField(String field) {
        String mod = field.replaceAll("\"", "\"\"");
        if (mod.matches(".*(\"|\n|,).*")) {
            mod = "\"" + mod + "\"";
        }
        return mod;
    }

    @Override
    public String getCapabilitiesElementName() {
        return "CSV";
    }
}

