/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.request;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.XlinkPropertyNameType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.request.RequestObject;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public abstract class Query
extends RequestObject {
    public static Query adapt(Object query) {
        if (query instanceof QueryType) {
            return new WFS11((EObject)query);
        }
        if (query instanceof net.opengis.wfs20.QueryType) {
            return new WFS20((EObject)query);
        }
        return null;
    }

    protected Query(EObject adaptee) {
        super(adaptee);
    }

    public URI getSrsName() {
        return this.eGet(this.adaptee, "srsName", URI.class);
    }

    public String getFeatureVersion() {
        return this.eGet(this.adaptee, "featureVersion", String.class);
    }

    @Override
    public abstract List<QName> getTypeNames();

    public abstract List<String> getAliases();

    public abstract List<String> getPropertyNames();

    @Override
    public abstract Filter getFilter();

    public abstract List<SortBy> getSortBy();

    public abstract List<XlinkPropertyNameType> getXlinkPropertyNames();

    public static class WFS20
    extends Query {
        public WFS20(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public List<QName> getTypeNames() {
            return this.eGet(this.adaptee, "typeNames", List.class);
        }

        @Override
        public List<String> getAliases() {
            return this.eGet(this.adaptee, "aliases", List.class);
        }

        @Override
        public List<String> getPropertyNames() {
            List propertyNames = this.eGet(this.adaptee, "abstractProjectionClause", List.class);
            ArrayList<String> l = new ArrayList<String>();
            for (QName name : propertyNames) {
                l.add(name.getLocalPart());
            }
            return l;
        }

        @Override
        public Filter getFilter() {
            return this.eGet(this.adaptee, "abstractSelectionClause", Filter.class);
        }

        @Override
        public List<SortBy> getSortBy() {
            return this.eGet(this.adaptee, "abstractSortingClause", List.class);
        }

        @Override
        public List<XlinkPropertyNameType> getXlinkPropertyNames() {
            return Collections.EMPTY_LIST;
        }
    }

    public static class WFS11
    extends Query {
        public WFS11(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public List<QName> getTypeNames() {
            return this.eGet(this.adaptee, "typeName", List.class);
        }

        @Override
        public List<String> getAliases() {
            return new ArrayList<String>();
        }

        @Override
        public List<String> getPropertyNames() {
            return this.eGet(this.adaptee, "propertyName", List.class);
        }

        @Override
        public Filter getFilter() {
            return this.eGet(this.adaptee, "filter", Filter.class);
        }

        @Override
        public List<SortBy> getSortBy() {
            return this.eGet(this.adaptee, "sortBy", List.class);
        }

        @Override
        public List<XlinkPropertyNameType> getXlinkPropertyNames() {
            return this.eGet(this.adaptee, "xlinkPropertyName", List.class);
        }
    }
}

