/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.request;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs20.LockFeatureType;
import net.opengis.wfs20.Wfs20Factory;
import net.opengis.wfs20.Wfs20Package;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.geoserver.wfs.request.Lock;
import org.geoserver.wfs.request.LockFeatureResponse;
import org.geoserver.wfs.request.RequestObject;

public abstract class LockFeatureRequest
extends RequestObject {
    public static LockFeatureRequest adapt(Object request) {
        if (request instanceof net.opengis.wfs.LockFeatureType) {
            return new WFS11((EObject)request);
        }
        if (request instanceof LockFeatureType) {
            return new WFS20((EObject)request);
        }
        return null;
    }

    protected LockFeatureRequest(EObject adaptee) {
        super(adaptee);
    }

    public BigInteger getExpiry() {
        return this.eGet(this.adaptee, "expiry", BigInteger.class);
    }

    public void setExpiry(BigInteger expiry) {
        this.eSet(this.adaptee, "expiry", expiry);
    }

    public abstract List<Lock> getLocks();

    public abstract void addLock(Lock var1);

    public abstract boolean isLockActionSome();

    public abstract void setLockActionSome();

    public abstract boolean isLockActionAll();

    public abstract void setLockActionAll();

    public abstract Lock createLock();

    public abstract LockFeatureResponse createResponse();

    public static class WFS20
    extends LockFeatureRequest {
        public WFS20(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public List<Lock> getLocks() {
            ArrayList<Lock> locks = new ArrayList<Lock>();
            for (Object lock : this.eGet(this.adaptee, "abstractQueryExpression", List.class)) {
                locks.add(new Lock.WFS20((EObject)lock));
            }
            return locks;
        }

        @Override
        public void addLock(Lock lock) {
            ((FeatureMap)this.eGet(this.adaptee, "abstractQueryExpressionGroup", List.class)).add((EStructuralFeature)Wfs20Package.Literals.DOCUMENT_ROOT__QUERY, (Object)lock.getAdaptee());
        }

        @Override
        public boolean isLockActionAll() {
            return ((LockFeatureType)this.adaptee).getLockAction() == net.opengis.wfs20.AllSomeType.ALL;
        }

        @Override
        public void setLockActionAll() {
            ((LockFeatureType)this.adaptee).setLockAction(net.opengis.wfs20.AllSomeType.ALL);
        }

        @Override
        public boolean isLockActionSome() {
            return ((LockFeatureType)this.adaptee).getLockAction() == net.opengis.wfs20.AllSomeType.SOME;
        }

        @Override
        public void setLockActionSome() {
            ((LockFeatureType)this.adaptee).setLockAction(net.opengis.wfs20.AllSomeType.SOME);
        }

        @Override
        public Lock createLock() {
            return new Lock.WFS20((EObject)((Wfs20Factory)this.getFactory()).createQueryType());
        }

        @Override
        public LockFeatureResponse createResponse() {
            return new LockFeatureResponse.WFS20((EObject)((Wfs20Factory)this.getFactory()).createLockFeatureResponseType());
        }
    }

    public static class WFS11
    extends LockFeatureRequest {
        public WFS11(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public List<Lock> getLocks() {
            ArrayList<Lock> locks = new ArrayList<Lock>();
            for (Object lock : this.eGet(this.adaptee, "lock", List.class)) {
                locks.add(new Lock.WFS11((EObject)lock));
            }
            return locks;
        }

        @Override
        public void addLock(Lock lock) {
            this.eGet(this.adaptee, "lock", List.class).add(lock.getAdaptee());
        }

        @Override
        public boolean isLockActionAll() {
            return ((net.opengis.wfs.LockFeatureType)this.adaptee).getLockAction() == AllSomeType.ALL_LITERAL;
        }

        @Override
        public void setLockActionAll() {
            ((net.opengis.wfs.LockFeatureType)this.adaptee).setLockAction(AllSomeType.ALL_LITERAL);
        }

        @Override
        public boolean isLockActionSome() {
            return ((net.opengis.wfs.LockFeatureType)this.adaptee).getLockAction() == AllSomeType.SOME_LITERAL;
        }

        @Override
        public void setLockActionSome() {
            ((net.opengis.wfs.LockFeatureType)this.adaptee).setLockAction(AllSomeType.SOME_LITERAL);
        }

        @Override
        public Lock createLock() {
            return new Lock.WFS11((EObject)((WfsFactory)this.getFactory()).createLockType());
        }

        @Override
        public LockFeatureResponse createResponse() {
            return new LockFeatureResponse.WFS11((EObject)((WfsFactory)this.getFactory()).createLockFeatureResponseType());
        }
    }
}

