/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.ows.FlatKvpParser;
import org.geoserver.wfs.WFSException;

public class QNameKvpParser
extends FlatKvpParser {
    protected Catalog catalog;
    private final boolean strict;

    public QNameKvpParser(String key, Catalog catalog) {
        this(key, catalog, true);
    }

    protected QNameKvpParser(String key, Catalog catalog, boolean strict) {
        super(key, QName.class);
        this.catalog = catalog;
        this.strict = strict;
    }

    protected Object parseToken(String token) throws Exception {
        int i = token.indexOf(58);
        if (i != -1) {
            String prefix = token.substring(0, i);
            String local = token.substring(i + 1);
            String uri = null;
            if (prefix != null && !"".equals(prefix)) {
                NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(prefix);
                if (this.strict && namespace == null) {
                    throw new WFSException("Unknown namespace [" + prefix + "]");
                }
                uri = namespace == null ? null : namespace.getURI();
            }
            return new QName(uri, local, prefix);
        }
        return new QName(token);
    }
}

