/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import com.vividsolutions.jts.geom.Envelope;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs20.ParameterExpressionType;
import net.opengis.wfs20.ParameterType;
import net.opengis.wfs20.StoredQueryType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.ows.util.NumericKvpParser;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.kvp.QNameKvpParser;
import org.geoserver.wfs.kvp.WFSKvpRequestReader;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.xml.EMFUtils;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.NamespaceSupport;

public class GetFeatureKvpRequestReader
extends WFSKvpRequestReader {
    Catalog catalog;
    FilterFactory filterFactory;

    public GetFeatureKvpRequestReader(Class requestBean, Catalog catalog, FilterFactory filterFactory) {
        this(requestBean, (EFactory)WfsFactory.eINSTANCE, catalog, filterFactory);
    }

    public GetFeatureKvpRequestReader(Class requestBean, EFactory factory, Catalog catalog, FilterFactory filterFactory) {
        super(requestBean, factory);
        this.catalog = catalog;
        this.filterFactory = filterFactory;
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        List<Object> filters;
        if (rawKvp.containsKey("startIndex")) {
            kvp.put("startIndex", new NumericKvpParser(null, BigInteger.class).parse((String)rawKvp.get("startIndex")));
        }
        request = super.read(request, kvp, rawKvp);
        EObject eObject = (EObject)request;
        this.ensureMutuallyExclusive(kvp, new String[]{"featureId", "resourceId", "filter", "bbox", "cql_filter"}, eObject);
        if (!EMFUtils.isSet((EObject)eObject, (String)"outputFormat")) {
            String version = (String)EMFUtils.get((EObject)eObject, (String)"version");
            switch (WFSInfo.Version.negotiate(version)) {
                case V_10: {
                    EMFUtils.set((EObject)eObject, (String)"outputFormat", (Object)"GML2");
                    break;
                }
                case V_11: {
                    EMFUtils.set((EObject)eObject, (String)"outputFormat", (Object)"text/xml; subtype=gml/3.1.1");
                    break;
                }
                default: {
                    EMFUtils.set((EObject)eObject, (String)"outputFormat", (Object)"text/xml; subtype=gml/3.2");
                }
            }
        }
        NamespaceSupport namespaces = null;
        if (kvp.containsKey("namespace")) {
            if (kvp.get("namespace") instanceof NamespaceSupport) {
                namespaces = (NamespaceSupport)kvp.get("namespace");
            } else {
                LOGGER.warning("There's a namespace parameter but it seems it wasn't parsed to a " + NamespaceSupport.class.getName() + ": " + kvp.get("namespace"));
            }
        }
        if (kvp.containsKey("typeName") || kvp.containsKey("typeNames")) {
            List typeName = (List)kvp.get("typeName");
            if (typeName == null) {
                typeName = (List)kvp.get("typeNames");
            }
            ArrayList<List> list = new ArrayList<List>();
            for (Object obj : typeName) {
                if (obj instanceof QName) {
                    QName qName = (QName)obj;
                    qName = this.checkTypeName(qName, namespaces, eObject);
                    ArrayList<QName> l = new ArrayList<QName>();
                    l.add(qName);
                    list.add(l);
                    continue;
                }
                List qNames = (List)obj;
                for (int i = 0; i < qNames.size(); ++i) {
                    qNames.set(i, this.checkTypeName((QName)qNames.get(i), namespaces, eObject));
                }
                list.add(qNames);
            }
            kvp.put("typeName", list);
            this.querySet(eObject, "typeName", list);
        } else if (kvp.containsKey("featureId") || kvp.containsKey("resourceId")) {
            List featureId = (List)kvp.get("featureId");
            featureId = featureId != null ? featureId : (List)kvp.get("resourceId");
            ArrayList<List> typeNames = new ArrayList<List>();
            QNameKvpParser parser = new QNameKvpParser("typeName", this.catalog);
            for (int i = 0; i < featureId.size(); ++i) {
                String fid = (String)featureId.get(i);
                int pos = fid.indexOf(".");
                if (pos == -1) continue;
                String typeName = fid.substring(0, fid.lastIndexOf("."));
                List parsed = (List)parser.parse(typeName);
                typeNames.add(parsed);
            }
            this.querySet(eObject, "typeName", typeNames);
        } else {
            List storedQueryId = null;
            if (kvp.containsKey("storedQuery_Id")) {
                storedQueryId = (List)kvp.get("storedQuery_Id");
            }
            if (storedQueryId == null && kvp.containsKey("storedQueryId")) {
                storedQueryId = (List)kvp.get("storedQueryId");
            }
            if (storedQueryId != null) {
                this.buildStoredQueries(eObject, storedQueryId, kvp);
            } else {
                throw new WFSException(eObject, "The query should specify either typeName, featureId filter, or a stored query id", "MissingParameterValue");
            }
        }
        if (kvp.containsKey("filter")) {
            this.querySet(eObject, "filter", (List)kvp.get("filter"));
        } else if (kvp.containsKey("cql_filter")) {
            this.querySet(eObject, "filter", (List)kvp.get("cql_filter"));
        } else if (kvp.containsKey("featureId") || kvp.containsKey("resourceId")) {
            List featureIdList = (List)kvp.get("featureId");
            featureIdList = featureIdList != null ? featureIdList : (List)kvp.get("resourceId");
            HashSet<FeatureId> ids = new HashSet<FeatureId>();
            for (String fid : featureIdList) {
                FeatureId featureId = this.filterFactory.featureId(fid);
                ids.add(featureId);
            }
            filters = Collections.singletonList(this.filterFactory.id(ids));
            this.querySet(eObject, "filter", filters);
        } else if (kvp.containsKey("bbox")) {
            Envelope bbox = (Envelope)kvp.get("bbox");
            List<Query> queries = GetFeatureRequest.adapt(eObject).getQueries();
            filters = new ArrayList();
            for (Query q : queries) {
                List<QName> typeName = q.getTypeNames();
                BBOX filter = null;
                if (typeName.size() > 1) {
                    ArrayList<BBOX> and = new ArrayList<BBOX>(typeName.size());
                    Iterator<QName> t = typeName.iterator();
                    while (t.hasNext()) {
                        and.add(this.bboxFilter(t.next(), bbox));
                    }
                    filter = this.filterFactory.and(and);
                } else {
                    filter = this.bboxFilter(typeName.get(0), bbox);
                }
                filters.add(filter);
            }
            this.querySet(eObject, "filter", filters);
        }
        if (kvp.containsKey("aliases")) {
            this.querySet(eObject, "aliases", (List)kvp.get("aliases"));
        }
        if (kvp.containsKey("propertyName")) {
            this.querySet(eObject, "propertyName", (List)kvp.get("propertyName"));
        }
        if (kvp.containsKey("sortBy")) {
            this.querySet(eObject, "sortBy", (List)kvp.get("sortBy"));
        }
        if (kvp.containsKey("srsName")) {
            this.querySet(eObject, "srsName", Collections.singletonList((URI)kvp.get("srsName")));
        }
        if (kvp.containsKey("featureVersion")) {
            this.querySet(eObject, "featureVersion", Collections.singletonList((String)kvp.get("featureVersion")));
        }
        GetFeatureRequest req = GetFeatureRequest.adapt(request);
        if (kvp.containsKey("format_options")) {
            req.getFormatOptions().putAll((Map)kvp.get("format_options"));
        }
        if (kvp.containsKey("viewParams")) {
            ArrayList viewParams;
            if (req.getMetadata() == null) {
                req.setMetadata(new HashMap());
            }
            if ((viewParams = (ArrayList)kvp.get("viewParams")).size() > 0) {
                int layerCount = req.getQueries().size();
                if (viewParams.size() == 1 && layerCount > 1) {
                    ArrayList replacement = new ArrayList();
                    for (int i = 0; i < layerCount; ++i) {
                        replacement.add(viewParams.get(0));
                    }
                    viewParams = replacement;
                } else if (viewParams.size() != layerCount) {
                    String msg = layerCount + " feature types requested, but found " + viewParams.size() + " view params specified. ";
                    throw new WFSException(eObject, msg, ((Object)((Object)this)).getClass().getName());
                }
            }
            req.getMetadata().put("GS_SQL_VIEW_PARAMS", viewParams);
        }
        return request;
    }

    private void ensureMutuallyExclusive(Map kvp, String[] keys, EObject request) {
        for (int i = 0; i < keys.length; ++i) {
            if (!kvp.containsKey(keys[i])) continue;
            for (int j = i + 1; j < keys.length; ++j) {
                if (!kvp.containsKey(keys[j])) continue;
                String msg = keys[i] + " and " + keys[j] + " both specified but are mutually exclusive";
                throw new WFSException(request, msg);
            }
        }
    }

    QName checkTypeName(QName qName, NamespaceSupport namespaces, EObject request) {
        String namespaceURI = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        String prefix = qName.getPrefix();
        if (namespaces != null) {
            if ("".equals(prefix)) {
                String uri = namespaces.getURI("");
                if (!"".equals(uri)) {
                    namespaceURI = uri;
                }
            } else if (namespaces.getURI(prefix) != null) {
                namespaceURI = namespaces.getURI(qName.getPrefix());
            }
            NamespaceInfo ns = this.catalog.getNamespaceByURI(namespaceURI);
            if (ns == null) {
                throw new WFSException("Unknown namespace [" + qName.getPrefix() + "]", "InvalidParameterValue", "namespace");
            }
            prefix = ns.getPrefix();
            qName = new QName(namespaceURI, localPart, prefix);
        }
        if (!"".equals(qName.getPrefix()) && this.catalog.getNamespaceByPrefix(qName.getPrefix()) == null) {
            throw new WFSException("Unknown namespace [" + qName.getPrefix() + "]", "InvalidParameterValue", "namespace");
        }
        if (this.catalog.getFeatureTypeByName(namespaceURI, localPart) == null) {
            String name = qName.getPrefix() + ":" + qName.getLocalPart();
            throw new WFSException("Feature type " + name + " unknown", "InvalidParameterValue", "typeName");
        }
        return qName;
    }

    BBOX bboxFilter(QName typeName, Envelope bbox) throws Exception {
        CoordinateReferenceSystem crs;
        FeatureTypeInfo featureTypeInfo = this.catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        String name = "";
        String epsgCode = null;
        if (bbox instanceof ReferencedEnvelope && (crs = ((ReferencedEnvelope)bbox).getCoordinateReferenceSystem()) != null) {
            epsgCode = GML2EncodingUtils.crs((CoordinateReferenceSystem)crs);
        }
        return this.filterFactory.bbox(name, bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), epsgCode);
    }

    protected void querySet(EObject request, String property, List values) throws WFSException {
        if (values == null) {
            return;
        }
        GetFeatureRequest req = GetFeatureRequest.adapt(request);
        if (req instanceof GetFeatureRequest.WFS20) {
            if ("typeName".equals(property)) {
                property = "typeNames";
            }
            if ("propertyName".equals(property)) {
                property = "abstractProjectionClause";
            }
        }
        List<Object> query = req.getAdaptedQueries();
        int m = values.size();
        int n = query.size();
        if (m == 1 && n > 1) {
            EMFUtils.set(query, (String)property, values.get(0));
            return;
        }
        if (m > n) {
            if (n == 0) {
                for (int i = 0; i < m; ++i) {
                    query.add(req.createQuery().getAdaptee());
                }
            } else {
                if (n == 1) {
                    EObject q = (EObject)query.get(0);
                    for (int i = 1; i < m; ++i) {
                        query.add(EMFUtils.clone((EObject)q, (EFactory)req.getFactory()));
                    }
                    return;
                }
                String msg = "Specified " + m + " " + property + " for " + n + " queries.";
                throw new WFSException(request, msg);
            }
        }
        EMFUtils.set(query, (String)property, (List)values);
    }

    protected void buildStoredQueries(EObject request, List<URI> storedQueryIds, Map kvp) {
        GetFeatureRequest req = GetFeatureRequest.adapt(request);
        req.getAdaptedQueries();
        if (!(req instanceof GetFeatureRequest.WFS20)) {
            throw new WFSException((RequestObject)req, "Stored queries only supported in WFS 2.0+");
        }
        StoredQueryProvider sqp = new StoredQueryProvider(this.catalog);
        for (URI storedQueryId : storedQueryIds) {
            StoredQuery sq = sqp.getStoredQuery(storedQueryId.toString());
            if (sq == null) {
                throw new WFSException((RequestObject)req, "No such stored query: " + storedQueryId);
            }
            Wfs20Factory factory = (Wfs20Factory)req.getFactory();
            StoredQueryType storedQuery = factory.createStoredQueryType();
            storedQuery.setId(storedQueryId.toString());
            for (ParameterExpressionType p : sq.getQuery().getParameter()) {
                if (!kvp.containsKey(p.getName())) continue;
                ParameterType param = factory.createParameterType();
                param.setName(p.getName());
                param.setValue(kvp.get(p.getName()).toString());
                storedQuery.getParameter().add((Object)param);
            }
            req.getAdaptedQueries().add(storedQuery);
        }
    }
}

