/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.GMLInfoImpl;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSInfoImpl;

public class WFSXStreamLoader
extends XStreamServiceLoader<WFSInfo> {
    public WFSXStreamLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader, "wfs");
    }

    protected void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        super.initXStreamPersister(xp, gs);
        xp.getXStream().alias("wfs", WFSInfo.class, WFSInfoImpl.class);
        xp.getXStream().alias("version", WFSInfo.Version.class);
        xp.getXStream().alias("gml", GMLInfo.class, GMLInfoImpl.class);
    }

    protected WFSInfo createServiceFromScratch(GeoServer gs) {
        WFSInfoImpl wfs = new WFSInfoImpl();
        wfs.setId("wfs");
        wfs.setName("WFS");
        GMLInfoImpl gml2 = new GMLInfoImpl();
        gml2.setSrsNameStyle(GMLInfo.SrsNameStyle.XML);
        gml2.setOverrideGMLAttributes(true);
        wfs.getGML().put(WFSInfo.Version.V_10, gml2);
        GMLInfoImpl gml3 = new GMLInfoImpl();
        gml3.setSrsNameStyle(GMLInfo.SrsNameStyle.URN);
        gml3.setOverrideGMLAttributes(false);
        wfs.getGML().put(WFSInfo.Version.V_11, gml3);
        return wfs;
    }

    public Class<WFSInfo> getServiceClass() {
        return WFSInfo.class;
    }

    protected WFSInfo initialize(WFSInfo service) {
        GMLInfo gml;
        super.initialize((ServiceInfo)service);
        if (service.getVersions().isEmpty()) {
            service.getVersions().add(WFSInfo.Version.V_10.getVersion());
            service.getVersions().add(WFSInfo.Version.V_11.getVersion());
        }
        if (!service.getVersions().contains(WFSInfo.Version.V_20.getVersion())) {
            service.getVersions().add(WFSInfo.Version.V_20.getVersion());
        }
        if ((gml = service.getGML().get((Object)WFSInfo.Version.V_10)).getOverrideGMLAttributes() == null) {
            gml.setOverrideGMLAttributes(true);
        }
        if ((gml = service.getGML().get((Object)WFSInfo.Version.V_11)).getOverrideGMLAttributes() == null) {
            gml.setOverrideGMLAttributes(false);
        }
        if ((gml = service.getGML().get((Object)WFSInfo.Version.V_20)) == null) {
            gml = new GMLInfoImpl();
            gml.setOverrideGMLAttributes(false);
            gml.setSrsNameStyle(GMLInfo.SrsNameStyle.URN2);
            service.getGML().put(WFSInfo.Version.V_20, gml);
        }
        return service;
    }
}

