/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.Request;
import org.geoserver.ows.WorkspaceQualifyingCallback;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.request.DescribeFeatureTypeRequest;
import org.geoserver.wfs.request.GetCapabilitiesRequest;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Insert;
import org.geoserver.wfs.request.Lock;
import org.geoserver.wfs.request.LockFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.opengis.feature.Feature;
import org.opengis.feature.type.Name;

public class WFSWorkspaceQualifier
extends WorkspaceQualifyingCallback {
    public WFSWorkspaceQualifier(Catalog catalog) {
        super(catalog);
    }

    protected void qualifyRequest(WorkspaceInfo workspace, LayerInfo layer, Service service, Request request) {
    }

    protected void qualifyRequest(WorkspaceInfo workspace, LayerInfo layer, Operation operation, Request request) {
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspace.getName());
        GetCapabilitiesRequest caps = GetCapabilitiesRequest.adapt(OwsUtils.parameter((Object[])operation.getParameters(), EObject.class));
        if (caps != null) {
            caps.setNamespace(workspace.getName());
            return;
        }
        DescribeFeatureTypeRequest dft = DescribeFeatureTypeRequest.adapt(OwsUtils.parameter((Object[])operation.getParameters(), EObject.class));
        if (dft != null) {
            this.qualifyTypeNames(dft.getTypeNames(), workspace, ns);
            return;
        }
        GetFeatureRequest gf = GetFeatureRequest.adapt(OwsUtils.parameter((Object[])operation.getParameters(), EObject.class));
        if (gf != null) {
            for (Query q : gf.getQueries()) {
                this.qualifyTypeNames(q.getTypeNames(), workspace, ns);
            }
            return;
        }
        LockFeatureRequest lf = LockFeatureRequest.adapt(OwsUtils.parameter((Object[])operation.getParameters(), EObject.class));
        if (lf != null) {
            for (Lock lock : lf.getLocks()) {
                lock.setTypeName(this.qualifyTypeName(lock.getTypeName(), workspace, ns));
            }
            return;
        }
        TransactionRequest t = TransactionRequest.adapt(OwsUtils.parameter((Object[])operation.getParameters(), EObject.class));
        if (t != null) {
            for (TransactionElement el : t.getElements()) {
                if (el instanceof Insert) {
                    Insert in = (Insert)el;
                    for (Feature f : in.getFeatures()) {
                        Name n = f.getType().getName();
                        if (n.getNamespaceURI() == null || ns.getURI().equals(n.getNamespaceURI())) continue;
                        throw new WFSException((RequestObject)t, "No such feature type " + n);
                    }
                    continue;
                }
                el.setTypeName(this.qualifyTypeName(el.getTypeName(), workspace, ns));
            }
        }
    }

    void qualifyTypeNames(List names, WorkspaceInfo ws, NamespaceInfo ns) {
        for (int i = 0; i < names.size(); ++i) {
            QName name = (QName)names.get(i);
            names.set(i, this.qualifyTypeName(name, ws, ns));
        }
    }

    QName qualifyTypeName(QName name, WorkspaceInfo ws, NamespaceInfo ns) {
        return new QName(ns.getURI(), name.getLocalPart(), ws.getName());
    }
}

