/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Map;
import org.geoserver.config.GeoServer;
import org.geoserver.config.util.LegacyServiceLoader;
import org.geoserver.config.util.LegacyServicesReader;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.GMLInfoImpl;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSInfoImpl;
import org.geotools.util.Version;

public class WFSLoader
extends LegacyServiceLoader<WFSInfo> {
    public Class<WFSInfo> getServiceClass() {
        return WFSInfo.class;
    }

    public WFSInfo load(LegacyServicesReader reader, GeoServer geoServer) throws Exception {
        WFSInfoImpl wfs = new WFSInfoImpl();
        wfs.setId("wfs");
        Map properties = reader.wfs();
        this.readCommon(wfs, properties, geoServer);
        wfs.setServiceLevel(WFSInfo.ServiceLevel.get((Integer)properties.get("serviceLevel")));
        Integer maxFeatures = (Integer)reader.global().get("maxFeatures");
        if (maxFeatures == null) {
            maxFeatures = Integer.MAX_VALUE;
        }
        wfs.setMaxFeatures(maxFeatures);
        Boolean featureBounding = (Boolean)properties.get("featureBounding");
        if (featureBounding != null) {
            wfs.setFeatureBounding(featureBounding);
        }
        GMLInfoImpl gml = new GMLInfoImpl();
        gml.setOverrideGMLAttributes(true);
        Boolean srsXmlStyle = (Boolean)properties.get("srsXmlStyle");
        if (srsXmlStyle.booleanValue()) {
            gml.setSrsNameStyle(GMLInfo.SrsNameStyle.XML);
        } else {
            gml.setSrsNameStyle(GMLInfo.SrsNameStyle.NORMAL);
        }
        wfs.getGML().put(WFSInfo.Version.V_10, gml);
        gml = new GMLInfoImpl();
        gml.setSrsNameStyle(GMLInfo.SrsNameStyle.URN);
        gml.setOverrideGMLAttributes(false);
        wfs.getGML().put(WFSInfo.Version.V_11, gml);
        gml = new GMLInfoImpl();
        gml.setSrsNameStyle(GMLInfo.SrsNameStyle.URN2);
        gml.setOverrideGMLAttributes(false);
        wfs.getGML().put(WFSInfo.Version.V_20, gml);
        wfs.getVersions().add(new Version("1.0.0"));
        wfs.getVersions().add(new Version("1.1.0"));
        wfs.getVersions().add(new Version("2.0.0"));
        return wfs;
    }
}

