/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.response.WFSResponse;
import org.geotools.util.logging.Logging;

public abstract class WFSGetFeatureOutputFormat
extends WFSResponse {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");

    public WFSGetFeatureOutputFormat(GeoServer gs, String outputFormat) {
        super(gs, FeatureCollectionResponse.class, outputFormat);
    }

    public WFSGetFeatureOutputFormat(GeoServer gs, Set<String> outputFormats) {
        super(gs, FeatureCollectionResponse.class, outputFormats);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public boolean canHandle(Operation operation) {
        GetFeatureRequest req;
        if (("GetFeature".equalsIgnoreCase(operation.getId()) || "GetFeatureWithLock".equalsIgnoreCase(operation.getId())) && (req = GetFeatureRequest.adapt(operation.getParameters()[0])).isResultTypeResults()) {
            return this.canHandleInternal(operation);
        }
        return false;
    }

    public String getCapabilitiesElementName() {
        LOGGER.severe("ERROR IN " + ((Object)((Object)this)).getClass() + " IMPLEMENTATION.  getCapabilitiesElementName() should return a" + "valid XML element name string for use in the WFS 1.0.0 capabilities document.");
        String of = this.getOutputFormat();
        if (of.matches("(\\w)+")) {
            return this.getOutputFormat();
        }
        String name = ((Object)((Object)this)).getClass().getName();
        if (name.indexOf(46) != -1) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    protected boolean canHandleInternal(Operation operation) {
        return true;
    }

    public final void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        if (value instanceof FeatureCollectionResponse) {
            this.write((FeatureCollectionResponse)value, output, operation);
        } else {
            this.write(FeatureCollectionResponse.adapt(value), output, operation);
        }
    }

    protected abstract void write(FeatureCollectionResponse var1, OutputStream var2, Operation var3) throws IOException, ServiceException;
}

