/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.RequestObject;

public class WFSException
extends ServiceException {
    public WFSException(RequestObject request, String message) {
        this(message);
        this.init(request);
    }

    public WFSException(RequestObject request, String message, String code) {
        this(message, code);
        this.init(request);
    }

    public WFSException(RequestObject request, String message, Throwable cause, String code) {
        this(message, cause, code);
        this.init(request);
    }

    public WFSException(RequestObject request, String message, Throwable cause) {
        this(message, cause);
        this.init(request);
    }

    public WFSException(RequestObject request, Throwable cause, String code) {
        this(cause, code);
        this.init(request);
    }

    public WFSException(RequestObject request, Throwable cause) {
        this(cause);
        this.init(request);
    }

    public WFSException(EObject request, String message) {
        this(message);
        this.init(request);
    }

    public WFSException(EObject request, String message, String code) {
        this(message, code);
        this.init(request);
    }

    public WFSException(EObject request, String message, Throwable cause, String code) {
        this(message, cause, code);
        this.init(request);
    }

    public WFSException(EObject request, String message, Throwable cause) {
        this(message, cause);
        this.init(request);
    }

    public WFSException(EObject request, Throwable cause, String code) {
        this(cause, code);
        this.init(request);
    }

    public WFSException(EObject request, Throwable cause) {
        this(cause);
        this.init(request);
    }

    public WFSException init(Object request) {
        if (request != null) {
            Object ver;
            WFSInfo.Version version;
            if (OwsUtils.has((Object)request, (String)"version") && (version = WFSInfo.Version.negotiate((ver = OwsUtils.get((Object)request, (String)"version")) != null ? ver.toString() : null)) != null && version.compareTo(WFSInfo.Version.V_20) < 0) {
                return this;
            }
            if (this.locator == null && OwsUtils.has((Object)request, (String)"handle")) {
                this.locator = (String)OwsUtils.get((Object)request, (String)"handle");
            }
            if (this.locator == null) {
                String className = request.getClass().getSimpleName();
                if (request instanceof RequestObject) {
                    className = request.getClass().getSuperclass().getSimpleName();
                    this.locator = className.substring(0, className.length() - "Request".length());
                } else if (className.endsWith("TypeImpl")) {
                    this.locator = className.substring(0, className.length() - "TypeImpl".length());
                }
            }
            if (this.code == null) {
                this.code = Code.OperationProcessingFailed.name();
            }
        }
        return this;
    }

    public WFSException(String message) {
        super(message);
    }

    public WFSException(Throwable cause) {
        super(cause);
    }

    public WFSException(String message, String code, String locator) {
        super(message, code, locator);
    }

    public WFSException(String message, String code) {
        super(message, code);
    }

    public WFSException(String message, Throwable cause, String code, String locator) {
        super(message, cause, code, locator);
    }

    public WFSException(String message, Throwable cause, String code) {
        super(message, cause, code);
    }

    public WFSException(String message, Throwable cause) {
        super(message, cause);
    }

    public WFSException(Throwable cause, String code, String locator) {
        super(cause, code, locator);
    }

    public WFSException(Throwable cause, String code) {
        super(cause, code);
    }

    public static enum Code {
        OperationProcessingFailed;

    }
}

