/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.AbstractTransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geoserver.wfs.WFSTransactionException;
import org.geoserver.wfs.request.Property;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geoserver.wfs.request.Update;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class UpdateElementHandler
extends AbstractTransactionElementHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");

    public UpdateElementHandler(GeoServer gs) {
        super(gs);
    }

    @Override
    public void checkValidity(TransactionElement element, Map<QName, FeatureTypeInfo> typeInfos) throws WFSTransactionException {
        if (!this.getInfo().getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_UPDATE)) {
            throw new WFSException((RequestObject)element, "Transaction Update support is not enabled");
        }
        Update update = (Update)element;
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        try {
            FeatureTypeInfo meta = typeInfos.values().iterator().next();
            FeatureType featureType = meta.getFeatureType();
            List<Property> props = update.getUpdateProperties();
            for (Property property : props) {
                if (property.getValue() == null) {
                    String propertyName = property.getName().getLocalPart();
                    AttributeDescriptor attributeType = null;
                    PropertyDescriptor pd = featureType.getDescriptor(propertyName);
                    if (pd instanceof AttributeDescriptor) {
                        attributeType = (AttributeDescriptor)pd;
                    }
                    if (attributeType != null && attributeType.getMinOccurs() > 0) {
                        String msg = "Property '" + attributeType.getLocalName() + "' is mandatory but no value specified.";
                        throw new WFSException((RequestObject)element, msg, "MissingParameterValue");
                    }
                }
                QName name = property.getName();
                PropertyName propertyName = null;
                propertyName = name.getPrefix() != null && !"".equals(name.getPrefix()) ? ff.property(name.getPrefix() + ":" + name.getLocalPart()) : ff.property(name.getLocalPart());
                if (propertyName.evaluate((Object)featureType) != null) continue;
                String msg = "No such property: " + name;
                throw new WFSException((RequestObject)element, msg);
            }
        }
        catch (IOException e) {
            throw new WFSTransactionException("Could not locate feature type information for " + update.getTypeName(), (Throwable)e, update.getHandle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TransactionElement element, TransactionRequest request, Map<QName, FeatureStore> featureStores, TransactionResponse response, TransactionListener listener) throws WFSTransactionException {
        HashSet<FeatureId> fids;
        block30: {
            Update update = (Update)element;
            QName elementName = update.getTypeName();
            String handle = update.getHandle();
            long updated = response.getTotalUpdated().longValue();
            SimpleFeatureStore store = DataUtilities.simple((FeatureStore)featureStores.get(elementName));
            if (store == null) {
                throw new WFSException((RequestObject)request, "Could not locate FeatureStore for '" + elementName + "'");
            }
            LOGGER.finer("Transaction Update:" + update);
            try {
                Object filter = update.getFilter();
                CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(store.getSchema(), request.getVersion());
                filter = filter != null ? WFSReprojectionUtil.normalizeFilterCRS(filter, store.getSchema(), declaredCRS) : Filter.INCLUDE;
                List<Property> properties = update.getUpdateProperties();
                AttributeDescriptor[] types = new AttributeDescriptor[properties.size()];
                String[] names = new String[properties.size()];
                Object[] values = new Object[properties.size()];
                for (int j = 0; j < properties.size(); ++j) {
                    Property property = properties.get(j);
                    QName propertyName = property.getName();
                    types[j] = ((SimpleFeatureType)store.getSchema()).getDescriptor(propertyName.getLocalPart());
                    names[j] = propertyName.getLocalPart();
                    values[j] = property.getValue();
                    if (!(values[j] instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)values[j];
                    CoordinateReferenceSystem source = null;
                    if (geometry.getUserData() instanceof CoordinateReferenceSystem) {
                        source = (CoordinateReferenceSystem)geometry.getUserData();
                    } else {
                        geometry.setUserData((Object)declaredCRS);
                        source = declaredCRS;
                    }
                    CoordinateReferenceSystem target = null;
                    if (types[j] instanceof GeometryDescriptor) {
                        target = ((GeometryDescriptor)types[j]).getCoordinateReferenceSystem();
                    }
                    if (this.getInfo().isCiteCompliant()) {
                        JTS.checkCoordinatesRange((Geometry)geometry, (CoordinateReferenceSystem)(source != null ? source : target));
                    }
                    if (source == null || target == null || CRS.equalsIgnoreMetadata((Object)source, (Object)target)) continue;
                    try {
                        MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target, (boolean)true);
                        GeometryCoordinateSequenceTransformer gtx = new GeometryCoordinateSequenceTransformer();
                        gtx.setMathTransform(tx);
                        values[j] = gtx.transform(geometry);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = "Failed to reproject geometry:" + e.getLocalizedMessage();
                        throw new WFSTransactionException(msg, (Throwable)e);
                    }
                }
                fids = new HashSet<FeatureId>();
                LOGGER.finer("Preprocess to remember modification as a set of fids");
                SimpleFeatureCollection features = store.getFeatures(filter);
                TransactionEvent event = new TransactionEvent(TransactionEventType.PRE_UPDATE, request, elementName, features);
                event.setSource(Update.WFS11.unadapt(update));
                listener.dataStoreChange(event);
                Iterator preprocess = features.iterator();
                try {
                    while (preprocess.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)preprocess.next();
                        fids.add(feature.getIdentifier());
                    }
                }
                catch (NoSuchElementException e) {
                    throw new WFSException((RequestObject)request, "Could not aquire FeatureIDs", (Throwable)e);
                }
                finally {
                    features.close(preprocess);
                }
                try {
                    store.modifyFeatures(names, values, filter);
                }
                catch (Exception e) {
                    throw new WFSTransactionException("Update error: " + e.getMessage(), (Throwable)e, "InvalidParameterValue");
                }
                finally {
                    if (request.getLockId() != null && store instanceof FeatureLocking && request.isReleaseActionSome()) {
                        SimpleFeatureLocking locking = (SimpleFeatureLocking)store;
                        locking.unLockFeatures(filter);
                    }
                }
                if (fids.isEmpty()) break block30;
                LOGGER.finer("Post process update for boundary update and featureValidation");
                HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
                Iterator f = fids.iterator();
                while (f.hasNext()) {
                    featureIds.add(ff.featureId(((FeatureId)f.next()).getID()));
                }
                Id modified = ff.id(featureIds);
                SimpleFeatureCollection changed = store.getFeatures((Filter)modified);
                HashSet<FeatureId> changedIds = new HashSet<FeatureId>();
                SimpleFeatureIterator iterator = changed.features();
                try {
                    while (iterator.hasNext()) {
                        changedIds.add(((SimpleFeature)iterator.next()).getIdentifier());
                    }
                }
                finally {
                    iterator.close();
                }
                response.addUpdatedFeatures(handle, changedIds);
                listener.dataStoreChange(new TransactionEvent(TransactionEventType.POST_UPDATE, request, elementName, changed, Update.WFS11.unadapt(update)));
            }
            catch (IOException ioException) {
                throw new WFSTransactionException(ioException, null, handle);
            }
            catch (PointOutsideEnvelopeException poe) {
                throw new WFSTransactionException(poe, null, handle);
            }
        }
        response.setTotalUpdated(BigInteger.valueOf(updated += (long)fids.size()));
    }

    public Class getElementClass() {
        return Update.class;
    }

    @Override
    public QName[] getTypeNames(TransactionElement element) throws WFSTransactionException {
        return new QName[]{element.getTypeName()};
    }
}

