/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.TransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.TransactionPlugin;
import org.geoserver.wfs.TransactionPluginComparator;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTransactionException;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class Transaction {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    protected WFSInfo wfs;
    protected Catalog catalog;
    protected FilterFactory filterFactory;
    protected org.geotools.data.Transaction transaction;
    protected List transactionElementHandlers = new ArrayList();
    protected List transactionListeners = new ArrayList();
    protected List transactionPlugins = new ArrayList();

    public Transaction(WFSInfo wfs, Catalog catalog, ApplicationContext context) {
        this.wfs = wfs;
        this.catalog = catalog;
        this.transactionElementHandlers.addAll(GeoServerExtensions.extensions(TransactionElementHandler.class));
        this.transactionListeners.addAll(GeoServerExtensions.extensions(TransactionListener.class));
        this.transactionPlugins.addAll(GeoServerExtensions.extensions(TransactionPlugin.class));
        this.transactionListeners.removeAll(this.transactionPlugins);
        Collections.sort(this.transactionPlugins, new TransactionPluginComparator());
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public TransactionResponse transaction(TransactionRequest request) throws WFSException {
        if (!this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
            throw new WFSException((RequestObject)request, "Transaction support is not enabled");
        }
        try {
            return this.execute(request);
        }
        catch (WFSException e) {
            this.abort(request);
            throw e;
        }
        catch (Throwable t) {
            this.abort(request);
            throw new WFSException((RequestObject)request, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionResponse execute(TransactionRequest request) throws Exception {
        if (request.getReleaseAction() == null) {
            request.setReleaseActionAll();
        }
        for (TransactionPlugin tp : this.transactionPlugins) {
            this.fireBeforeTransaction(request, tp);
        }
        TransactionListenerMux multiplexer = new TransactionListenerMux();
        this.transaction = this.getDatastoreTransaction(request);
        HashMap<QName, FeatureStore> stores = new HashMap<QName, FeatureStore>();
        HashMap<String, FeatureSource> stores2 = new HashMap<String, FeatureSource>();
        Map elementHandlers = this.gatherElementHandlers(request);
        for (Map.Entry entry : elementHandlers.entrySet()) {
            TransactionElement element = (TransactionElement)entry.getKey();
            TransactionElementHandler handler = (TransactionElementHandler)entry.getValue();
            HashMap<QName, FeatureTypeInfo> featureTypeInfos = new HashMap<QName, FeatureTypeInfo>();
            QName[] typeNames = handler.getTypeNames(element);
            for (int i = 0; i < typeNames.length; ++i) {
                QName typeName = typeNames[i];
                String name = typeName.getLocalPart();
                String namespaceURI = typeName.getNamespaceURI() != null ? typeName.getNamespaceURI() : this.catalog.getDefaultNamespace().getURI();
                LOGGER.fine("Locating FeatureSource uri:'" + namespaceURI + "' name:'" + name + "'");
                FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(namespaceURI, name);
                if (meta == null) {
                    String msg = "Feature type '" + name + "' is not available: ";
                    throw new WFSTransactionException(msg, (String)null, element.getHandle());
                }
                featureTypeInfos.put(typeName, meta);
            }
            handler.checkValidity(element, featureTypeInfos);
            for (FeatureTypeInfo meta : featureTypeInfos.values()) {
                String msg;
                String typeRef = meta.getStore().getName() + ":" + meta.getName();
                String URI2 = meta.getNamespace().getURI();
                QName elementName = new QName(URI2, meta.getName(), meta.getNamespace().getPrefix());
                QName elementNameDefault = null;
                if (this.catalog.getDefaultNamespace().getURI().equals(URI2)) {
                    elementNameDefault = new QName(meta.getName());
                }
                LOGGER.fine("located FeatureType w/ typeRef '" + typeRef + "' and elementName '" + elementName + "'");
                if (stores.containsKey(elementName)) continue;
                try {
                    FeatureSource source = meta.getFeatureSource(null, null);
                    if (source instanceof FeatureStore) {
                        FeatureStore store = (FeatureStore)source;
                        store.setTransaction(this.transaction);
                        stores.put(elementName, (FeatureStore)source);
                        if (elementNameDefault != null) {
                            stores.put(elementNameDefault, (FeatureStore)source);
                        }
                        stores2.put(typeRef, source);
                        continue;
                    }
                    msg = elementName + " is read-only";
                    throw new WFSTransactionException(msg, (String)null, element.getHandle());
                }
                catch (IOException ioException) {
                    msg = elementName + " is not available: " + ioException.getLocalizedMessage();
                    throw new WFSTransactionException(msg, (Throwable)ioException, element.getHandle());
                }
            }
        }
        String authorizationID = request.getLockId();
        if (authorizationID != null) {
            if (!this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.LOCKFEATURE)) {
                throw new WFSException((RequestObject)request, "Lock support is not enabled");
            }
            LOGGER.finer("got lockId: " + authorizationID);
            if (!this.lockExists(authorizationID)) {
                String mesg = "Attempting to use a lockID that does not exist, it has either expired or was entered wrong.";
                throw new WFSException((RequestObject)request, mesg, "InvalidParameterValue");
            }
            try {
                this.transaction.addAuthorization(authorizationID);
            }
            catch (IOException ioException) {
                throw new WFSException((RequestObject)request, "Authorization ID '" + authorizationID + "' not useable", (Throwable)ioException);
            }
        }
        TransactionResponse result = request.createResponse();
        result.setHandle(request.getHandle());
        WFSException exception = null;
        try {
            for (Map.Entry entry : elementHandlers.entrySet()) {
                TransactionElement element = (TransactionElement)entry.getKey();
                TransactionElementHandler handler = (TransactionElementHandler)entry.getValue();
                handler.execute(element, request, stores, result, multiplexer);
            }
        }
        catch (WFSTransactionException e) {
            LOGGER.log(Level.SEVERE, "Transaction failed", (Throwable)((Object)e));
            exception = e;
            if (request.getVersion().startsWith("2") && e.getCause() instanceof FeatureLockException && request.getLockId() == null) {
                exception = new WFSTransactionException(e.getMessage(), (Throwable)((Object)e), "MissingParameterValue");
            }
            result.addAction(e.getCode() != null ? e.getCode() : "InvalidParameterValue", e.getLocator(), e.getMessage());
        }
        boolean committed = false;
        try {
            if (exception != null) {
                this.transaction.rollback();
            } else {
                for (TransactionPlugin tp : this.transactionPlugins) {
                    this.fireBeforeCommit(request, tp);
                }
                this.transaction.commit();
                committed = true;
                String lockId = request.getLockId();
                if (lockId != null) {
                    if (request.isReleaseActionAll()) {
                        this.lockRelease(lockId);
                    } else if (request.isReleaseActionSome()) {
                        this.lockRefresh(lockId);
                    }
                }
            }
        }
        finally {
            this.transaction.close();
            this.transaction = null;
        }
        for (TransactionPlugin tp : this.transactionPlugins) {
            this.fireAfterTransaction(request, result, committed, tp);
        }
        if (exception != null && request.getVersion() != null && request.getVersion().startsWith("2")) {
            if (!(exception instanceof WFSException) || ((WFSException)exception).getCode() == null) {
                exception = new WFSException((RequestObject)request, (Throwable)((Object)exception));
            }
            throw exception;
        }
        List insertedFeatures = result.getInsertedFeatures();
        if (insertedFeatures != null && insertedFeatures.isEmpty()) {
            result.addInsertedFeature(null, this.filterFactory.featureId("none"));
        }
        return result;
    }

    void fireAfterTransaction(TransactionRequest request, TransactionResponse result, boolean committed, TransactionPlugin tp) {
        TransactionType tx = TransactionRequest.WFS11.unadapt(request);
        TransactionResponseType tr = TransactionResponse.WFS11.unadapt(result);
        if (tx != null && tr != null) {
            tp.afterTransaction(tx, tr, committed);
        }
    }

    void fireBeforeCommit(TransactionRequest request, TransactionPlugin tp) {
        TransactionType tx = TransactionRequest.WFS11.unadapt(request);
        if (tx != null) {
            tp.beforeCommit(tx);
        }
    }

    void fireBeforeTransaction(TransactionRequest request, TransactionPlugin tp) {
        TransactionType tx = TransactionRequest.WFS11.unadapt(request);
        if (tx != null) {
            tp.beforeTransaction(tx);
        }
    }

    private Map gatherElementHandlers(TransactionRequest request) throws WFSTransactionException {
        LinkedHashMap<TransactionElement, TransactionElementHandler> map = new LinkedHashMap<TransactionElement, TransactionElementHandler>();
        List<TransactionElement> elements = request.getElements();
        for (TransactionElement element : elements) {
            map.put(element, this.findElementHandler(element.getClass()));
        }
        return map;
    }

    protected final TransactionElementHandler findElementHandler(Class type) throws WFSTransactionException {
        ArrayList<TransactionElementHandler> matches = new ArrayList<TransactionElementHandler>();
        for (TransactionElementHandler handler : this.transactionElementHandlers) {
            if (!handler.getElementClass().isAssignableFrom(type)) continue;
            matches.add(handler);
        }
        if (matches.isEmpty()) {
            String msg = "No transaction element handler for : ( " + type + " )";
            throw new WFSTransactionException(msg);
        }
        if (matches.size() > 1) {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    TransactionElementHandler h1 = (TransactionElementHandler)o1;
                    TransactionElementHandler h2 = (TransactionElementHandler)o2;
                    if (h2.getElementClass().isAssignableFrom(h1.getElementClass())) {
                        return -1;
                    }
                    return 1;
                }
            };
            Collections.sort(matches, comparator);
        }
        return (TransactionElementHandler)matches.get(0);
    }

    protected DefaultTransaction getDatastoreTransaction(TransactionRequest request) throws IOException {
        Object principal;
        DefaultTransaction transaction = new DefaultTransaction();
        String username = "anonymous";
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && (principal = authentication.getPrincipal()) instanceof UserDetails) {
            username = ((UserDetails)principal).getUsername();
        }
        transaction.putProperty((Object)"VersioningCommitAuthor", (Object)username);
        transaction.putProperty((Object)"VersioningCommitMessage", (Object)request.getHandle());
        return transaction;
    }

    public void abort(TransactionRequest request) {
        if (this.transaction == null) {
            return;
        }
        try {
            this.transaction.rollback();
            this.transaction.close();
        }
        catch (IOException ioException) {
            LOGGER.log(Level.SEVERE, "Failed trying to rollback a transaction:" + ioException);
        }
        String lockId = request.getLockId();
        if (lockId != null) {
            if (request.isReleaseActionSome()) {
                try {
                    this.lockRefresh(lockId);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error occured refreshing lock", e);
                }
            } else if (request.isReleaseActionAll()) {
                try {
                    this.lockRelease(lockId);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error occured releasing lock", e);
                }
            }
        }
    }

    void lockRelease(String lockId) throws WFSException {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        lockFeature.release(lockId);
    }

    private boolean lockExists(String lockId) throws Exception {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        return lockFeature.exists(lockId);
    }

    private void lockRefresh(String lockId) throws Exception {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        lockFeature.refresh(lockId);
    }

    private class TransactionListenerMux
    implements TransactionListener {
        private TransactionListenerMux() {
        }

        public void dataStoreChange(List listeners, TransactionEvent event) throws WFSException {
            for (TransactionListener listener : listeners) {
                listener.dataStoreChange(event);
            }
        }

        @Override
        public void dataStoreChange(TransactionEvent event) throws WFSException {
            this.dataStoreChange(Transaction.this.transactionPlugins, event);
            this.dataStoreChange(Transaction.this.transactionListeners, event);
        }
    }
}

