/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs20.StoredQueryDescriptionType;
import org.geoserver.catalog.Catalog;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.StoredQuery;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.Parser;

public class StoredQueryProvider {
    public static String LANGUAGE = "urn:ogc:def:queryLanguage:OGC-WFS::WFS_QueryExpression";
    static Logger LOGGER = Logging.getLogger(StoredQueryProvider.class);
    Catalog catalog;
    GeoServerResourceLoader loader;

    public StoredQueryProvider(Catalog catalog) {
        this.catalog = catalog;
        this.loader = catalog.getResourceLoader();
    }

    public String getLanguage() {
        return LANGUAGE;
    }

    public List<StoredQuery> listStoredQueries() {
        Parser p = new Parser((Configuration)new WFSConfiguration());
        ArrayList<StoredQuery> queries = new ArrayList<StoredQuery>();
        queries.add(StoredQuery.DEFAULT);
        try {
            File dir = this.storedQueryDir();
            for (String f : dir.list()) {
                try {
                    queries.add(this.parseStoredQuery(new File(dir, f), p));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error occured parsing stored query: " + f, e);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("i/o error listing stored queries", e);
        }
        return queries;
    }

    public StoredQuery createStoredQuery(StoredQueryDescriptionType query) {
        return this.createStoredQuery(query, true);
    }

    public StoredQuery createStoredQuery(StoredQueryDescriptionType query, boolean store) {
        StoredQuery sq = new StoredQuery(query, this.catalog);
        if (store) {
            this.putStoredQuery(sq);
        }
        return sq;
    }

    public void removeStoredQuery(StoredQuery query) {
        try {
            File f = new File(this.storedQueryDir(), this.toFilename(query.getName()));
            if (f.exists()) {
                f.delete();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StoredQuery getStoredQuery(String name) {
        if (StoredQuery.DEFAULT.getName().equals(name)) {
            return StoredQuery.DEFAULT;
        }
        try {
            File dir = this.storedQueryDir();
            File f = new File(dir, this.toFilename(name));
            if (!f.exists()) {
                return null;
            }
            return this.parseStoredQuery(f);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessign stoed query: " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putStoredQuery(StoredQuery query) {
        try {
            File dir = this.storedQueryDir();
            File f = new File(dir, this.toFilename(query.getName()));
            if (f.exists()) {
                // empty if block
            }
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(f));
            try {
                Encoder e = new Encoder((Configuration)new WFSConfiguration());
                e.setRootElementType(WFS.StoredQueryDescriptionType);
                e.encode((Object)query.getQuery(), WFS.StoredQueryDescription, (OutputStream)new BufferedOutputStream(bout));
                bout.flush();
            }
            finally {
                bout.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("i/o error listing stored queries", e);
        }
    }

    String toFilename(String name) {
        return name.replaceAll("\\W", "") + ".xml";
    }

    File storedQueryDir() throws IOException {
        File dir = this.loader.find(new String[]{"wfs", "query"});
        if (dir != null) {
            return dir;
        }
        return this.loader.findOrCreateDirectory(new String[]{"wfs", "stored_queries"});
    }

    StoredQuery parseStoredQuery(File file) throws Exception {
        return this.parseStoredQuery(file, new Parser((Configuration)new WFSConfiguration()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoredQuery parseStoredQuery(File file, Parser p) throws Exception {
        p.setRootElementType(WFS.StoredQueryDescriptionType);
        FileInputStream fin = new FileInputStream(file);
        try {
            StoredQueryDescriptionType q = (StoredQueryDescriptionType)p.parse((InputStream)new BufferedInputStream(fin));
            StoredQuery storedQuery = this.createStoredQuery(q);
            return storedQuery;
        }
        finally {
            fin.close();
        }
    }
}

