/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geoserver.wfs.request.Lock;
import org.geoserver.wfs.request.LockFeatureRequest;
import org.geoserver.wfs.request.LockFeatureResponse;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LockFeature {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    WFSInfo wfs;
    Catalog catalog;
    FilterFactory filterFactory;

    public LockFeature(WFSInfo wfs, Catalog catalog) {
        this(wfs, catalog, null);
    }

    public LockFeature(WFSInfo wfs, Catalog catalog, FilterFactory filterFactory) {
        this.wfs = wfs;
        this.catalog = catalog;
        this.filterFactory = filterFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockFeatureResponse lockFeature(LockFeatureRequest request) throws WFSException {
        FeatureLock fLock = null;
        try {
            List<Lock> locks = request.getLocks();
            if (locks == null || locks.isEmpty()) {
                String msg = "A LockFeature request must contain at least one LOCK element";
                throw new WFSException((RequestObject)request, msg);
            }
            LOGGER.info("locks size is " + locks.size());
            fLock = this.newFeatureLock(request);
            LockFeatureResponse response = request.createResponse();
            response.setLockId(fLock.getAuthorization());
            int n = locks.size();
            for (int i = 0; i < n; ++i) {
                FeatureCollection features;
                FeatureSource source;
                FeatureTypeInfo meta;
                Lock lock = locks.get(i);
                LOGGER.info("curLock is " + lock);
                QName typeName = lock.getTypeName();
                Filter filter = lock.getFilter();
                if (filter == null) {
                    filter = Filter.INCLUDE;
                }
                try {
                    meta = this.catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
                    if (meta == null) {
                        throw new WFSException((RequestObject)request, "Unknown feature type " + typeName.getPrefix() + ":" + typeName.getLocalPart());
                    }
                    source = meta.getFeatureSource(null, null);
                    CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(source.getSchema(), request.getVersion());
                    filter = WFSReprojectionUtil.normalizeFilterCRS(filter, source.getSchema(), declaredCRS);
                    features = source.getFeatures(filter);
                    if (source instanceof FeatureLocking) {
                        ((FeatureLocking)source).setFeatureLock(fLock);
                    }
                }
                catch (IOException e) {
                    throw new WFSException((RequestObject)request, (Throwable)e);
                }
                Iterator reader = null;
                int numberLocked = -1;
                try {
                    for (SimpleFeature feature : features) {
                        FeatureId fid = this.fid(feature.getID());
                        Id fidFilter = this.fidFilter(fid);
                        if (!(source instanceof FeatureLocking)) {
                            LOGGER.fine("Lock " + fid + " not supported by data store (authID:" + fLock.getAuthorization() + ")");
                            response.addNotLockedFeature(fid);
                            continue;
                        }
                        Query query = new Query(meta.getName(), (Filter)fidFilter, Integer.MAX_VALUE, Query.ALL_NAMES, lock.getHandle());
                        numberLocked = ((FeatureLocking)source).lockFeatures(query);
                        if (numberLocked == 1) {
                            LOGGER.fine("Lock " + fid + " (authID:" + fLock.getAuthorization() + ")");
                            response.addLockedFeature(fid);
                            continue;
                        }
                        if (numberLocked == 0) {
                            LOGGER.fine("Lock " + fid + " conflict (authID:" + fLock.getAuthorization() + ")");
                            response.addNotLockedFeature(fid);
                            continue;
                        }
                        LOGGER.warning("Lock " + numberLocked + " " + fid + " (authID:" + fLock.getAuthorization() + ") duplicated FeatureID!");
                        response.addLockedFeature(fid);
                    }
                }
                catch (IOException ioe) {
                    throw new WFSException((RequestObject)request, (Throwable)ioe);
                }
                finally {
                    if (reader != null) {
                        features.close(reader);
                    }
                }
                if (numberLocked <= 0) continue;
                DefaultTransaction t = new DefaultTransaction();
                try {
                    try {
                        t.addAuthorization(fLock.getAuthorization());
                        DataStore dataStore = (DataStore)source.getDataStore();
                        dataStore.getLockingManager().refresh(fLock.getAuthorization(), (Transaction)t);
                        continue;
                    }
                    finally {
                        t.commit();
                    }
                }
                catch (IOException e) {
                    throw new WFSException((RequestObject)request, (Throwable)e);
                }
                finally {
                    try {
                        t.close();
                    }
                    catch (IOException e) {
                        throw new WFSException((RequestObject)request, (Throwable)e);
                    }
                }
            }
            boolean lockAll = !request.isLockActionSome();
            List<FeatureId> notLocked = response.getNotLockedFeatures();
            if (lockAll && notLocked != null && !notLocked.isEmpty()) {
                throw new WFSException((RequestObject)request, "Could not aquire locks for:" + notLocked);
            }
            return response;
        }
        catch (WFSException e) {
            if (fLock != null) {
                try {
                    this.release(fLock.getAuthorization());
                }
                catch (WFSException e1) {
                    LOGGER.log(Level.SEVERE, "Error occured releasing locks", (Throwable)((Object)e1));
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release(String lockId) throws WFSException {
        try {
            boolean refresh = false;
            List dataStores = this.catalog.getDataStores();
            for (DataStoreInfo meta : dataStores) {
                LockingManager lockingManager;
                DataAccess da;
                DataStore dataStore = null;
                if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                    dataStore = (DataStore)da;
                }
                if (dataStore == null || (lockingManager = dataStore.getLockingManager()) == null) continue;
                DefaultTransaction t = new DefaultTransaction("Refresh " + meta.getWorkspace().getName());
                try {
                    t.addAuthorization(lockId);
                    if (!lockingManager.release(lockId, (Transaction)t)) continue;
                    refresh = true;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
                finally {
                    try {
                        t.close();
                    }
                    catch (IOException closeException) {
                        LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                    }
                }
            }
            if (refresh) return;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    public void releaseAll() throws WFSException {
        try {
            List dataStores = this.catalog.getDataStores();
            for (DataStoreInfo meta : dataStores) {
                LockingManager lockingManager;
                DataAccess da;
                DataStore dataStore = null;
                if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                    dataStore = (DataStore)da;
                }
                if (dataStore != null && (lockingManager = dataStore.getLockingManager()) != null) continue;
            }
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    public boolean exists(String lockId) throws WFSException {
        try {
            List dataStores = this.catalog.getDataStores();
            for (DataStoreInfo meta : dataStores) {
                LockingManager lockingManager;
                DataAccess da;
                DataStore dataStore = null;
                if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                    dataStore = (DataStore)da;
                }
                if (dataStore == null || (lockingManager = dataStore.getLockingManager()) == null || !lockingManager.exists(lockId)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refresh(String lockId) throws WFSException {
        try {
            boolean refresh = false;
            List dataStores = this.catalog.getDataStores();
            for (DataStoreInfo meta : dataStores) {
                LockingManager lockingManager;
                DataAccess da;
                DataStore dataStore = null;
                if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                    dataStore = (DataStore)da;
                }
                if (dataStore == null || (lockingManager = dataStore.getLockingManager()) == null) continue;
                DefaultTransaction t = new DefaultTransaction("Refresh " + meta.getWorkspace().getName());
                try {
                    t.addAuthorization(lockId);
                    if (!lockingManager.refresh(lockId, (Transaction)t)) continue;
                    refresh = true;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
                finally {
                    try {
                        t.close();
                    }
                    catch (IOException closeException) {
                        LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                    }
                }
            }
            if (refresh) return;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    private FeatureId fid(String fid) {
        return this.filterFactory.featureId(fid);
    }

    private Id fidFilter(FeatureId fid) {
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(fid);
        return this.filterFactory.id(ids);
    }

    protected FeatureLock newFeatureLock(LockFeatureRequest request) {
        int lockExpiry;
        BigInteger expiry;
        String handle = request.getHandle();
        if (handle == null || handle.equals("")) {
            handle = "GeoServer";
            request.setHandle(handle);
        }
        if ((expiry = request.getExpiry()) == null) {
            expiry = BigInteger.valueOf(0L);
            request.setExpiry(expiry);
        }
        if ((lockExpiry = expiry.intValue()) < 0) {
            return FeatureLockFactory.generate((String)handle, (long)lockExpiry);
        }
        if (lockExpiry == 0) {
            return FeatureLockFactory.generate((String)handle, (long)0L);
        }
        return FeatureLockFactory.generate((String)handle, (long)(lockExpiry * 60 * 1000));
    }
}

