/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import javax.xml.namespace.QName;
import net.opengis.wfs20.ListStoredQueriesResponseType;
import net.opengis.wfs20.ListStoredQueriesType;
import net.opengis.wfs20.StoredQueryListItemType;
import net.opengis.wfs20.TitleType;
import net.opengis.wfs20.Wfs20Factory;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;

public class ListStoredQueries {
    WFSInfo wfs;
    StoredQueryProvider storedQueryProvider;

    public ListStoredQueries(WFSInfo wfs, StoredQueryProvider storedQueryProvider) {
        this.wfs = wfs;
        this.storedQueryProvider = storedQueryProvider;
    }

    public ListStoredQueriesResponseType run(ListStoredQueriesType request) throws WFSException {
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        ListStoredQueriesResponseType response = factory.createListStoredQueriesResponseType();
        for (StoredQuery sq : this.storedQueryProvider.listStoredQueries()) {
            StoredQueryListItemType item = factory.createStoredQueryListItemType();
            item.setId(sq.getName());
            TitleType title = factory.createTitleType();
            title.setValue(sq.getTitle());
            item.getTitle().add((Object)title);
            if (!sq.getFeatureTypes().isEmpty()) {
                item.getReturnFeatureType().addAll(sq.getFeatureTypes());
            } else {
                item.getReturnFeatureType().add((Object)new QName(""));
            }
            response.getStoredQuery().add((Object)item);
        }
        return response;
    }
}

