/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geotools.data.Join;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.filter.visitor.FilterVisitorSupport;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.temporal.BinaryTemporalOperator;

public class JoinExtractingVisitor
extends FilterVisitorSupport {
    static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    FeatureTypeInfo primaryFeatureType;
    String primaryAlias;
    List<FeatureTypeInfo> featureTypes;
    List<String> aliases;
    List<Filter> joinFilters = new ArrayList<Filter>();
    List<Filter> filters = new ArrayList<Filter>();

    public JoinExtractingVisitor(List<FeatureTypeInfo> featureTypes, List<String> aliases) {
        this.primaryFeatureType = featureTypes.get(0);
        this.featureTypes = featureTypes.subList(1, featureTypes.size());
        if (aliases == null || aliases.isEmpty()) {
            aliases = new ArrayList<String>();
            for (int i = 0; i < featureTypes.size(); ++i) {
                aliases.add(String.valueOf((char)(97 + i)));
            }
        }
        this.primaryAlias = aliases.get(0);
        this.aliases = aliases.subList(1, aliases.size());
    }

    public Object visitNullFilter(Object extraData) {
        return null;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(Id filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(Not filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    protected Object visit(BinaryLogicOperator op, Object extraData) {
        for (Filter f : op.getChildren()) {
            f.accept((FilterVisitor)this, extraData);
        }
        return extraData;
    }

    protected Object visit(BinaryComparisonOperator op, Object extraData) {
        return this.handle((Filter)op, op.getExpression1(), op.getExpression2(), extraData);
    }

    protected Object visit(BinarySpatialOperator op, Object extraData) {
        return this.handle((Filter)op, op.getExpression1(), op.getExpression2(), extraData);
    }

    protected Object visit(BinaryTemporalOperator op, Object extraData) {
        return this.handle((Filter)op, op.getExpression1(), op.getExpression2(), extraData);
    }

    Object handle(Filter f, Expression e1, Expression e2, Object extraData) {
        if (this.isJoinFilter(e1, e2)) {
            this.joinFilters.add(f);
        } else {
            this.handleOther(f, extraData);
        }
        return null;
    }

    Object handleOther(Filter f, Object extraData) {
        this.filters.add(f);
        return null;
    }

    boolean isJoinFilter(Expression e1, Expression e2) {
        return e1 instanceof PropertyName && e2 instanceof PropertyName;
    }

    public List<Join> getJoins() {
        ArrayList<Join> joins = new ArrayList<Join>();
        List<Filter> joinFilters = this.rewriteAndSort(this.unroll(this.joinFilters), true);
        List<Filter> otherFilters = this.rewriteAndSort(this.unroll(this.filters), false);
        for (int i = 0; i < this.featureTypes.size(); ++i) {
            Join join = new Join(this.featureTypes.get(i).getNativeName(), joinFilters.get(i + 1));
            if (this.aliases != null) {
                join.setAlias(this.aliases.get(i));
            }
            if (otherFilters.get(i + 1) != null) {
                join.setFilter(otherFilters.get(i + 1));
            }
            joins.add(join);
        }
        return joins;
    }

    public Filter getPrimaryFilter() {
        List<Filter> otherFilters = this.rewriteAndSort(this.unroll(this.filters), false);
        return otherFilters.get(0);
    }

    List<Filter> unroll(List<Filter> filters) {
        JoinFilterUnroller unroller = new JoinFilterUnroller();
        for (Filter f : filters) {
            f.accept((FilterVisitor)unroller, null);
        }
        return unroller.getFilters();
    }

    List<Filter> rewriteAndSort(List<Filter> filters, boolean prefix) {
        Filter[] sorted = new Filter[this.featureTypes.size() + 1];
        block0: for (Filter f : filters) {
            PropertyName[] names = this.names(f);
            for (int i = 0; i < this.featureTypes.size(); ++i) {
                PropertyName[] rewritten = this.rewrite(i, names[0], names[1], prefix);
                if (rewritten == null) continue;
                Filter newFilter = this.rewrite(f, names, rewritten);
                this.updateFilter(sorted, i + 1, newFilter);
                continue block0;
            }
            PropertyName[] rewritten = this.rewrite(this.primaryFeatureType, this.primaryAlias, names[0], names[1], prefix);
            if (rewritten != null) {
                Filter newFilter = this.rewrite(f, names, rewritten);
                this.updateFilter(sorted, 0, newFilter);
                continue;
            }
            throw new IllegalStateException("Join filter inconsistent with regard to feature types");
        }
        return Arrays.asList(sorted);
    }

    void updateFilter(Filter[] filters, int i, Filter filter) {
        filters[i] = filters[i] == null ? filter : ff.and(filters[i], filter);
    }

    PropertyName[] rewrite(int i, PropertyName n1, PropertyName n2, boolean prefix) {
        FeatureTypeInfo featureType = this.featureTypes.get(i);
        String alias = this.aliases != null ? this.aliases.get(i) : null;
        return this.rewrite(featureType, alias, n1, n2, prefix);
    }

    PropertyName[] rewrite(FeatureTypeInfo featureType, String alias, PropertyName n1, PropertyName n2, boolean prefix) {
        PropertyName n;
        if (n1 != null && (n = this.rewrite(featureType, alias, n1, prefix)) != null) {
            return new PropertyName[]{n, n2 != null ? this.rewrite(this.primaryFeatureType, this.primaryAlias, n2, prefix) : null};
        }
        if (n2 != null && (n = this.rewrite(featureType, alias, n2, prefix)) != null) {
            return new PropertyName[]{n1 != null ? this.rewrite(this.primaryFeatureType, this.primaryAlias, n1, prefix) : null, n};
        }
        return null;
    }

    PropertyName rewrite(FeatureTypeInfo featureType, String alias, PropertyName name, boolean prefix) {
        String n = name.getPropertyName();
        n = n.startsWith(featureType.getPrefixedName() + "/") ? n.substring((featureType.getPrefixedName() + "/").length()) : (n.startsWith(featureType.getName() + "/") ? n.substring((featureType.getName() + "/").length()) : (alias != null && n.startsWith(alias + "/") ? n.substring((alias + "/").length()) : null));
        if (n != null) {
            if (prefix) {
                n = (alias != null ? alias : "") + "." + n;
            }
            return ff.property(n, name.getNamespaceContext());
        }
        return null;
    }

    Filter rewrite(Filter f, PropertyName[] names, PropertyName[] rewritten) {
        Filter newFilter = null;
        if (names[0] != null) {
            newFilter = (Filter)f.accept((FilterVisitor)new PropertyNameRewriter(names[0], rewritten[0]), null);
        }
        if (names[1] != null) {
            newFilter = (Filter)(newFilter != null ? newFilter : f).accept((FilterVisitor)new PropertyNameRewriter(names[1], rewritten[1]), null);
        }
        return newFilter;
    }

    PropertyName[] names(Filter f) {
        Expression e1 = null;
        Expression e2 = null;
        if (f instanceof BinaryComparisonOperator) {
            e1 = ((BinaryComparisonOperator)f).getExpression1();
            e2 = ((BinaryComparisonOperator)f).getExpression2();
        } else if (f instanceof BinarySpatialOperator) {
            e1 = ((BinarySpatialOperator)f).getExpression1();
            e2 = ((BinarySpatialOperator)f).getExpression2();
        } else if (f instanceof BinaryTemporalOperator) {
            e1 = ((BinaryTemporalOperator)f).getExpression1();
            e2 = ((BinaryTemporalOperator)f).getExpression2();
        } else if (f instanceof PropertyIsNil) {
            e1 = ((PropertyIsNil)f).getExpression();
        } else if (f instanceof PropertyIsNull) {
            e1 = ((PropertyIsNull)f).getExpression();
        } else if (f instanceof PropertyIsLike) {
            e1 = ((PropertyIsLike)f).getExpression();
        } else if (f instanceof PropertyIsBetween) {
            e1 = ((PropertyIsBetween)f).getExpression();
        } else {
            throw new IllegalStateException();
        }
        return new PropertyName[]{e1 instanceof PropertyName ? (PropertyName)e1 : null, e2 instanceof PropertyName ? (PropertyName)e2 : null};
    }

    class PropertyNameRewriter
    extends DuplicatingFilterVisitor {
        PropertyName from;
        PropertyName to;

        PropertyNameRewriter(PropertyName from, PropertyName to) {
            this.from = from;
            this.to = to;
        }

        public Object visit(PropertyName expression, Object extraData) {
            if (expression.equals(this.from)) {
                return this.to;
            }
            return super.visit(expression, extraData);
        }
    }

    class JoinFilterUnroller
    extends FilterVisitorSupport {
        List<Filter> unrolled = new ArrayList<Filter>();

        JoinFilterUnroller() {
        }

        public Object visitNullFilter(Object extraData) {
            return null;
        }

        public Object visit(ExcludeFilter filter, Object extraData) {
            return this.handle((Filter)filter, extraData);
        }

        public Object visit(IncludeFilter filter, Object extraData) {
            return this.handle((Filter)filter, extraData);
        }

        public Object visit(Id filter, Object extraData) {
            return this.handle((Filter)filter, extraData);
        }

        public Object visit(PropertyIsBetween filter, Object extraData) {
            return this.handle((Filter)filter, extraData);
        }

        public Object visit(PropertyIsLike filter, Object extraData) {
            return this.handle((Filter)filter, extraData);
        }

        public Object visit(PropertyIsNil filter, Object extraData) {
            return this.handle((Filter)filter, extraData);
        }

        public Object visit(PropertyIsNull filter, Object extraData) {
            return this.handle((Filter)filter, extraData);
        }

        public Object visit(Not filter, Object extraData) {
            return null;
        }

        protected Object visit(BinaryLogicOperator op, Object extraData) {
            if (op instanceof And) {
                for (Filter f : op.getChildren()) {
                    f.accept((FilterVisitor)this, extraData);
                }
            }
            return null;
        }

        protected Object visit(BinaryComparisonOperator op, Object extraData) {
            return this.handle((Filter)op, extraData);
        }

        protected Object visit(BinarySpatialOperator op, Object extraData) {
            return this.handle((Filter)op, extraData);
        }

        protected Object visit(BinaryTemporalOperator op, Object extraData) {
            return this.handle((Filter)op, extraData);
        }

        protected Object handle(Filter filter, Object extraData) {
            this.unrolled.add(filter);
            return extraData;
        }

        public List<Filter> getFilters() {
            return this.unrolled;
        }
    }
}

