/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import javax.xml.namespace.QName;
import net.opengis.wfs20.FeatureCollectionType;
import net.opengis.wfs20.GetFeatureType;
import net.opengis.wfs20.GetPropertyValueType;
import net.opengis.wfs20.QueryType;
import net.opengis.wfs20.ResolveValueType;
import net.opengis.wfs20.ValueCollectionType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.GetFeature;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geotools.feature.FeatureCollection;
import org.geotools.wfs.PropertyValueCollection;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.PropertyDescriptor;

public class GetPropertyValue {
    GetFeature delegate;
    Catalog catalog;

    public GetPropertyValue(WFSInfo info, Catalog catalog) {
        this.delegate = new GetFeature(info, catalog);
        this.catalog = catalog;
    }

    public ValueCollectionType run(GetPropertyValueType request) throws WFSException {
        if (request.isSetResolve() && !ResolveValueType.NONE.equals((Object)request.getResolve())) {
            throw new WFSException((EObject)request, "Only resolve = none is supported", "InvalidParameterValue").locator("resolve");
        }
        if (request.getValueReference() == null) {
            throw new WFSException((EObject)request, "No valueReference specified", "MissingParameterValue").locator("valueReference");
        }
        GetFeatureType getFeature = Wfs20Factory.eINSTANCE.createGetFeatureType();
        getFeature.getAbstractQueryExpression().add((Object)request.getAbstractQueryExpression());
        FeatureCollectionType fc = (FeatureCollectionType)this.delegate.run(GetFeatureRequest.adapt(getFeature)).getAdaptee();
        QueryType query = (QueryType)request.getAbstractQueryExpression();
        QName typeName = (QName)query.getTypeNames().iterator().next();
        FeatureTypeInfo featureType = this.catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        try {
            PropertyDescriptor pd;
            AttributeTypeInfo attribute = null;
            for (AttributeTypeInfo at : featureType.attributes()) {
                if (!at.getName().equals(request.getValueReference())) continue;
                attribute = at;
                break;
            }
            if (attribute == null) {
                throw new WFSException((EObject)request, "No such attribute: " + request.getValueReference());
            }
            AttributeDescriptor descriptor = attribute.getAttribute();
            if (descriptor == null && (pd = featureType.getFeatureType().getDescriptor(attribute.getName())) instanceof AttributeDescriptor) {
                descriptor = (AttributeDescriptor)pd;
            }
            if (descriptor == null) {
                throw new WFSException((EObject)request, "Unable to obtain descriptor for " + attribute.getName());
            }
            ValueCollectionType vc = Wfs20Factory.eINSTANCE.createValueCollectionType();
            vc.setTimeStamp(fc.getTimeStamp());
            vc.setNumberMatched(fc.getNumberMatched());
            vc.setNumberReturned(fc.getNumberReturned());
            vc.getMember().add((Object)new PropertyValueCollection((FeatureCollection)fc.getMember().iterator().next(), descriptor));
            return vc;
        }
        catch (IOException e) {
            throw new WFSException((EObject)request, (Throwable)e);
        }
    }
}

