/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.wfs.CapabilitiesTransformer;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.GetCapabilitiesRequest;
import org.geoserver.wfs.request.RequestObject;

public class GetCapabilities {
    WFSInfo wfs;
    Catalog catalog;

    public GetCapabilities(WFSInfo wfs, Catalog catalog) {
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public CapabilitiesTransformer run(GetCapabilitiesRequest request) throws WFSException {
        CapabilitiesTransformer capsTransformer;
        List<String> accepted;
        String version;
        if (this.wfs.isCiteCompliant() && request.getUpdateSequence() != null) {
            throw new WFSException((RequestObject)request, "Invalid update sequence", "InvalidUpdateSequence");
        }
        if (this.wfs.isCiteCompliant() && !request.isSetService()) {
            throw new WFSException("Service not set", "MissingParameterValue", "service");
        }
        ArrayList<String> provided = new ArrayList<String>();
        provided.add("1.0.0");
        provided.add("1.1.0");
        if (request instanceof GetCapabilitiesRequest.WFS20) {
            provided.add("2.0.0");
        }
        if ("1.0.0".equals(version = RequestUtils.getVersionPreOws(provided, accepted = request.getAcceptVersions()))) {
            capsTransformer = new CapabilitiesTransformer.WFS1_0(this.wfs, this.catalog);
        } else if ("1.1.0".equals(version)) {
            capsTransformer = new CapabilitiesTransformer.WFS1_1(this.wfs, this.catalog);
        } else if ("2.0.0".equals(version)) {
            capsTransformer = new CapabilitiesTransformer.WFS2_0(this.wfs, this.catalog);
        } else {
            throw new WFSException((RequestObject)request, "Could not understand version:" + version);
        }
        capsTransformer.setEncoding(Charset.forName(this.wfs.getGeoServer().getSettings().getCharset()));
        return capsTransformer;
    }
}

