/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.Serializable;
import org.geotools.gml2.SrsSyntax;

public interface GMLInfo
extends Serializable {
    public SrsNameStyle getSrsNameStyle();

    public void setSrsNameStyle(SrsNameStyle var1);

    public Boolean getOverrideGMLAttributes();

    public void setOverrideGMLAttributes(Boolean var1);

    public static enum SrsNameStyle {
        NORMAL{

            @Override
            public SrsSyntax toSrsSyntax() {
                return SrsSyntax.EPSG_CODE;
            }
        }
        ,
        XML{

            @Override
            public SrsSyntax toSrsSyntax() {
                return SrsSyntax.OGC_HTTP_URL;
            }
        }
        ,
        URN{

            @Override
            public SrsSyntax toSrsSyntax() {
                return SrsSyntax.OGC_URN_EXPERIMENTAL;
            }
        }
        ,
        URN2{

            @Override
            public SrsSyntax toSrsSyntax() {
                return SrsSyntax.OGC_URN;
            }
        }
        ,
        URL{

            @Override
            public SrsSyntax toSrsSyntax() {
                return SrsSyntax.OGC_HTTP_URI;
            }
        };


        public String getPrefix() {
            return this.toSrsSyntax().getPrefix();
        }

        public abstract SrsSyntax toSrsSyntax();

        public SrsNameStyle fromSrsSyntax(SrsSyntax srsSyntax) {
            for (SrsNameStyle s : SrsNameStyle.values()) {
                if (s.toSrsSyntax() != srsSyntax) continue;
                return s;
            }
            return null;
        }
    }
}

